Qpid Proton - AMQP messaging toolkit
====================================

Linux Build | Windows Build
------------|--------------
[![Linux Build Status](https://travis-ci.org/apache/qpid-proton.svg?branch=master)](https://travis-ci.org/apache/qpid-proton) | [![Windows Build Status](https://ci.appveyor.com/api/projects/status/github/apache/qpid-proton?branch=master&svg=true)](https://ci.appveyor.com/project/ke4qqq/qpid-proton/branch/master)

Qpid Proton is a high-performance, lightweight messaging library. It can be
used in the widest range of messaging applications, including brokers, client
libraries, routers, bridges, proxies, and more. Proton makes it trivial to
integrate with the AMQP 1.0 ecosystem from any platform, environment, or
language

Features
--------

  - A flexible and capable reactive messaging API
  - Full control of AMQP 1.0 protocol semantics
  - Portable C implementation with bindings to popular languages
  - Peer-to-peer and brokered messaging
  - Secure communication via SSL and SASL

Universal - Proton is designed to scale both up and down. Equally suitable for
simple clients or high-powered servers, it can be deployed in simple
peer-to-peer configurations or as part of a global federated messaging network.

Embeddable - Proton is carefully written to be portable and cross platform. It
has minimal dependencies, and it is architected to be usable with any threading
model, as well as with non-threaded applications. These features make it
uniquely suited for embedding messaging capabilities into existing software.

Standard - Built around the AMQP 1.0 messaging standard, Proton is not only
ideal for building out your own messaging applications but also for connecting
them to the broader ecosystem of AMQP 1.0-based messaging applications.

Getting Started
---------------

See the included INSTALL.md file for build and install instructions and the
DEVELOPERS file for information on how to modify and test the library code
itself.

Please see http://qpid.apache.org/proton for a more info.
