/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/enmasseproject/enmasse/pkg/apis/iot/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IoTConfigLister helps list IoTConfigs.
type IoTConfigLister interface {
	// List lists all IoTConfigs in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.IoTConfig, err error)
	// IoTConfigs returns an object that can list and get IoTConfigs.
	IoTConfigs(namespace string) IoTConfigNamespaceLister
	IoTConfigListerExpansion
}

// ioTConfigLister implements the IoTConfigLister interface.
type ioTConfigLister struct {
	indexer cache.Indexer
}

// NewIoTConfigLister returns a new IoTConfigLister.
func NewIoTConfigLister(indexer cache.Indexer) IoTConfigLister {
	return &ioTConfigLister{indexer: indexer}
}

// List lists all IoTConfigs in the indexer.
func (s *ioTConfigLister) List(selector labels.Selector) (ret []*v1alpha1.IoTConfig, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.IoTConfig))
	})
	return ret, err
}

// IoTConfigs returns an object that can list and get IoTConfigs.
func (s *ioTConfigLister) IoTConfigs(namespace string) IoTConfigNamespaceLister {
	return ioTConfigNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IoTConfigNamespaceLister helps list and get IoTConfigs.
type IoTConfigNamespaceLister interface {
	// List lists all IoTConfigs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.IoTConfig, err error)
	// Get retrieves the IoTConfig from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.IoTConfig, error)
	IoTConfigNamespaceListerExpansion
}

// ioTConfigNamespaceLister implements the IoTConfigNamespaceLister
// interface.
type ioTConfigNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all IoTConfigs in the indexer for a given namespace.
func (s ioTConfigNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.IoTConfig, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.IoTConfig))
	})
	return ret, err
}

// Get retrieves the IoTConfig from the indexer for a given namespace and name.
func (s ioTConfigNamespaceLister) Get(name string) (*v1alpha1.IoTConfig, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("iotconfig"), name)
	}
	return obj.(*v1alpha1.IoTConfig), nil
}
