/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	time "time"

	adminv1beta1 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta1"
	versioned "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned"
	internalinterfaces "github.com/enmasseproject/enmasse/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/enmasseproject/enmasse/pkg/client/listers/admin/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// AuthenticationServiceInformer provides access to a shared informer and lister for
// AuthenticationServices.
type AuthenticationServiceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.AuthenticationServiceLister
}

type authenticationServiceInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewAuthenticationServiceInformer constructs a new informer for AuthenticationService type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAuthenticationServiceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAuthenticationServiceInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredAuthenticationServiceInformer constructs a new informer for AuthenticationService type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAuthenticationServiceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AdminV1beta1().AuthenticationServices(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AdminV1beta1().AuthenticationServices(namespace).Watch(options)
			},
		},
		&adminv1beta1.AuthenticationService{},
		resyncPeriod,
		indexers,
	)
}

func (f *authenticationServiceInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAuthenticationServiceInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *authenticationServiceInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&adminv1beta1.AuthenticationService{}, f.defaultInformer)
}

func (f *authenticationServiceInformer) Lister() v1beta1.AuthenticationServiceLister {
	return v1beta1.NewAuthenticationServiceLister(f.Informer().GetIndexer())
}
