/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	time "time"

	userv1beta1 "github.com/enmasseproject/enmasse/pkg/apis/user/v1beta1"
	versioned "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned"
	internalinterfaces "github.com/enmasseproject/enmasse/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/enmasseproject/enmasse/pkg/client/listers/user/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// MessagingUserInformer provides access to a shared informer and lister for
// MessagingUsers.
type MessagingUserInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.MessagingUserLister
}

type messagingUserInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewMessagingUserInformer constructs a new informer for MessagingUser type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewMessagingUserInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredMessagingUserInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredMessagingUserInformer constructs a new informer for MessagingUser type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredMessagingUserInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.UserV1beta1().MessagingUsers(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.UserV1beta1().MessagingUsers(namespace).Watch(options)
			},
		},
		&userv1beta1.MessagingUser{},
		resyncPeriod,
		indexers,
	)
}

func (f *messagingUserInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredMessagingUserInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *messagingUserInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&userv1beta1.MessagingUser{}, f.defaultInformer)
}

func (f *messagingUserInformer) Lister() v1beta1.MessagingUserLister {
	return v1beta1.NewMessagingUserLister(f.Informer().GetIndexer())
}
