"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * A dictionary of symbols for each key, when pressed with the alt key also held.
 * Used for combinations that involve the alt key and one or more others. (e.g.
 * shift+a)
 */
var AltedKeysDictionary = {
  '`': ['`'],
  '1': ['¡'],
  '2': ['™'],
  '3': ['£'],
  '4': ['¢'],
  '5': ['∞'],
  '6': ['§'],
  '7': ['¶'],
  '8': ['•'],
  '9': ['ª'],
  '0': ['º'],
  '-': ['–'],
  '=': ['≠'],
  'a': ['å'],
  'b': ['∫'],
  'c': ['ç'],
  'd': ['∂'],
  'e': ['´'],
  'f': ['ƒ'],
  'g': ['©'],
  'h': ['˙'],
  'i': ['ˆ'],
  'j': ['∆'],
  'k': ['˚'],
  'l': ['¬'],
  'm': ['µ'],
  'n': ['˜'],
  'o': ['ø'],
  'p': ['π'],
  'q': ['œ'],
  'r': ['®'],
  's': ['ß'],
  't': ['†'],
  'u': ['¨'],
  'v': ['√'],
  'w': ['∑'],
  'x': ['≈'],
  'y': ['¥'],
  'z': ['Ω'],
  '[': ['“'],
  ']': ['‘'],
  "\\": ['«'],
  "'": ['æ'],
  ';': ['…'],
  ',': ['≤'],
  '.': ['≥'],
  '/': ['÷']
};
var _default = AltedKeysDictionary;
exports.default = _default;