"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * Returns the element in an array at a particular index from the end
 * @param {Array.<T>} array Array to iterate over to find the item
 * @param {Number} placesFromEnd Number of places from the end of the array to find
 *        the item to return
 * @returns {T} The item found in the array at the particular index
 * @template T
 */
function indexFromEnd(array, placesFromEnd) {
  return array[array.length - (placesFromEnd + 1)];
}

var _default = indexFromEnd;
exports.default = _default;