/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.Transferable;

public class StrimziKafkaContainer
extends GenericContainer<StrimziKafkaContainer> {
    private static final Logger LOGGER = LogManager.getLogger(StrimziKafkaContainer.class);
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    private static final int KAFKA_PORT = 9092;
    private static final int ZOOKEEPER_PORT = 2181;
    private static final String LATEST_KAFKA_VERSION;
    private int kafkaExposedPort;
    private StringBuilder advertisedListeners;
    private static List<String> supportedKafkaVersions;

    public StrimziKafkaContainer(String version) {
        super("strimzi/kafka:" + version);
        super.withNetwork(Network.SHARED);
        this.withExposedPorts(new Integer[]{9092});
        this.withEnv("LOG_DIR", "/tmp");
    }

    public StrimziKafkaContainer() {
        this("latest-kafka-" + LATEST_KAFKA_VERSION);
    }

    protected void doStart() {
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
        super.doStart();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        this.kafkaExposedPort = this.getMappedPort(9092);
        LOGGER.info("This is mapped port {}", (Object)this.kafkaExposedPort);
        this.advertisedListeners = new StringBuilder(this.getBootstrapServers());
        Collection cns = containerInfo.getNetworkSettings().getNetworks().values();
        for (ContainerNetwork cn : cns) {
            this.advertisedListeners.append(",BROKER://").append(cn.getIpAddress()).append(":9093");
        }
        LOGGER.info("This is all advertised listeners for Kafka {}", (Object)this.advertisedListeners.toString());
        String command = "#!/bin/bash \n";
        command = command + "bin/zookeeper-server-start.sh config/zookeeper.properties &\n";
        command = command + "bin/kafka-server-start.sh config/server.properties --override listeners=BROKER://0.0.0.0:9093,PLAINTEXT://0.0.0.0:9092 --override advertised.listeners=" + this.advertisedListeners.toString() + " --override zookeeper.connect=localhost:" + 2181 + " --override listener.security.protocol.map=BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT --override inter.broker.listener.name=BROKER\n";
        LOGGER.info("Copying command to 'STARTER_SCRIPT' script.");
        this.copyFileToContainer(Transferable.of((byte[])command.getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getContainerIpAddress(), this.kafkaExposedPort);
    }

    public static List<String> getSupportedKafkaVersions() {
        return supportedKafkaVersions;
    }

    public static String getLatestKafkaVersion() {
        return LATEST_KAFKA_VERSION;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        supportedKafkaVersions = new ArrayList<String>(3);
        InputStream inputStream = StrimziKafkaContainer.class.getResourceAsStream("/kafka-versions.txt");
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        try {
            String kafkaVersion;
            while ((kafkaVersion = bufferedReader.readLine()) != null) {
                supportedKafkaVersions.add(kafkaVersion);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOGGER.info("This is all supported Kafka versions {}", (Object)supportedKafkaVersions.toString());
        Collections.sort(supportedKafkaVersions);
        LATEST_KAFKA_VERSION = supportedKafkaVersions.get(supportedKafkaVersions.size() - 1);
    }
}

