/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.strimzi.systemtest.enums.ClusterOperatorInstallType;
import io.strimzi.test.TestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Environment {
    private static final Logger LOGGER = LogManager.getLogger(Environment.class);
    private static final Map<String, String> VALUES = new HashMap<String, String>();
    private static final JsonNode JSON_DATA = Environment.loadConfigurationFile();
    private static final String CONFIG_FILE_PATH_ENVAR = "ST_CONFIG_PATH";
    private static final String STRIMZI_IMAGE_PULL_SECRET_ENV = "SYSTEM_TEST_STRIMZI_IMAGE_PULL_SECRET";
    private static final String STRIMZI_ORG_ENV = "DOCKER_ORG";
    private static final String STRIMZI_REGISTRY_ENV = "DOCKER_REGISTRY";
    private static final String STRIMZI_TAG_ENV = "DOCKER_TAG";
    private static final String TEST_CLIENT_IMAGE_ENV = "TEST_CLIENT_IMAGE";
    private static final String BRIDGE_IMAGE_ENV = "BRIDGE_IMAGE";
    private static final String TEST_LOG_DIR_ENV = "TEST_LOG_DIR";
    private static final String ST_KAFKA_VERSION_ENV = "ST_KAFKA_VERSION";
    private static final String STRIMZI_LOG_LEVEL_ENV = "STRIMZI_DEFAULT_LOG_LEVEL";
    private static final String KUBERNETES_DOMAIN_ENV = "KUBERNETES_DOMAIN";
    private static final String COMPONENTS_IMAGE_PULL_POLICY_ENV = "COMPONENTS_IMAGE_PULL_POLICY";
    private static final String OPERATOR_IMAGE_PULL_POLICY_ENV = "OPERATOR_IMAGE_PULL_POLICY";
    private static final String STRIMZI_FULL_RECONCILIATION_INTERVAL_MS_ENV = "STRIMZI_FULL_RECONCILIATION_INTERVAL_MS";
    private static final String STRIMZI_RBAC_SCOPE_ENV = "STRIMZI_RBAC_SCOPE";
    private static final String STRIMZI_RBAC_SCOPE_CLUSTER = "CLUSTER";
    private static final String STRIMZI_RBAC_SCOPE_NAMESPACE = "NAMESPACE";
    private static final String STRIMZI_RBAC_SCOPE_DEFAULT = "CLUSTER";
    private static final String OLM_OPERATOR_NAME_ENV = "OLM_OPERATOR_NAME";
    private static final String OLM_OPERATOR_DEPLOYMENT_NAME_ENV = "OLM_OPERATOR_DEPLOYMENT_NAME";
    private static final String OLM_SOURCE_NAME_ENV = "OLM_SOURCE_NAME";
    private static final String OLM_SOURCE_NAMESPACE_ENV = "OLM_SOURCE_NAMESPACE";
    private static final String OLM_APP_BUNDLE_PREFIX_ENV = "OLM_APP_BUNDLE_PREFIX";
    private static final String OLM_OPERATOR_VERSION_ENV = "OLM_OPERATOR_VERSION";
    private static final String OLM_LATEST_CONTAINER_IMAGE_TAG_ENV = "OLM_LATEST_CONTAINER_IMAGE_TAG";
    private static final String DEFAULT_TO_DENY_NETWORK_POLICIES_ENV = "DEFAULT_TO_DENY_NETWORK_POLICIES";
    private static final String CLUSTER_OPERATOR_INSTALL_TYPE_ENV = "CLUSTER_OPERATOR_INSTALL_TYPE";
    private static final String SKIP_TEARDOWN_ENV = "SKIP_TEARDOWN";
    private static final String ST_KAFKA_VERSION_DEFAULT = "2.7.0";
    public static final String STRIMZI_ORG_DEFAULT = "strimzi";
    public static final String STRIMZI_TAG_DEFAULT = "latest";
    public static final String STRIMZI_REGISTRY_DEFAULT = "quay.io";
    public static final String STRIMZI_CLIENTS_ORG_DEFAULT = "strimzi-examples";
    private static final String TEST_LOG_DIR_DEFAULT = TestUtils.USER_PATH + "/../systemtest/target/logs/";
    private static final String STRIMZI_LOG_LEVEL_DEFAULT = "DEBUG";
    static final String KUBERNETES_DOMAIN_DEFAULT = ".nip.io";
    public static final String COMPONENTS_IMAGE_PULL_POLICY_ENV_DEFAULT = "IfNotPresent";
    public static final String OPERATOR_IMAGE_PULL_POLICY_ENV_DEFAULT = "Always";
    public static final String OLM_OPERATOR_NAME_DEFAULT = "strimzi-kafka-operator";
    public static final String OLM_OPERATOR_DEPLOYMENT_NAME_DEFAULT = "strimzi-cluster-operator";
    public static final String OLM_SOURCE_NAME_DEFAULT = "strimzi-source";
    public static final String OLM_APP_BUNDLE_PREFIX_DEFAULT = "strimzi-cluster-operator";
    public static final String OLM_OPERATOR_VERSION_DEFAULT = "0.21.1";
    private static final boolean DEFAULT_TO_DENY_NETWORK_POLICIES_DEFAULT = true;
    private static final ClusterOperatorInstallType CLUSTER_OPERATOR_INSTALL_TYPE_DEFAULT = ClusterOperatorInstallType.BUNDLE;
    private static String config;
    public static final String SYSTEM_TEST_STRIMZI_IMAGE_PULL_SECRET;
    public static final String STRIMZI_ORG;
    public static final String STRIMZI_TAG;
    public static final String STRIMZI_REGISTRY;
    public static final String TEST_LOG_DIR;
    public static final String ST_KAFKA_VERSION;
    public static final String STRIMZI_LOG_LEVEL;
    public static final String KUBERNETES_DOMAIN;
    public static final boolean SKIP_TEARDOWN;
    public static final String STRIMZI_RBAC_SCOPE;
    private static final String TEST_CLIENT_IMAGE_DEFAULT;
    public static final String TEST_CLIENT_IMAGE;
    private static final String BRIDGE_IMAGE_DEFAULT = "latest-released";
    public static final String BRIDGE_IMAGE;
    public static final String COMPONENTS_IMAGE_PULL_POLICY;
    public static final String OPERATOR_IMAGE_PULL_POLICY;
    public static final String OLM_OPERATOR_NAME;
    public static final String OLM_OPERATOR_DEPLOYMENT_NAME;
    public static final String OLM_SOURCE_NAME;
    public static final String OLM_SOURCE_NAMESPACE;
    public static final String OLM_APP_BUNDLE_PREFIX;
    public static final String OLM_OPERATOR_LATEST_RELEASE_VERSION;
    public static final boolean DEFAULT_TO_DENY_NETWORK_POLICIES;
    public static final ClusterOperatorInstallType CLUSTER_OPERATOR_INSTALL_TYPE;

    private Environment() {
    }

    public static boolean isOlmInstall() {
        return CLUSTER_OPERATOR_INSTALL_TYPE.equals((Object)ClusterOperatorInstallType.OLM);
    }

    public static boolean isHelmInstall() {
        return CLUSTER_OPERATOR_INSTALL_TYPE.equals((Object)ClusterOperatorInstallType.HELM);
    }

    public static boolean isNamespaceRbacScope() {
        return STRIMZI_RBAC_SCOPE_NAMESPACE.equals(STRIMZI_RBAC_SCOPE);
    }

    public static boolean useLatestReleasedBridge() {
        return BRIDGE_IMAGE.equals(BRIDGE_IMAGE_DEFAULT);
    }

    private static String getOrDefault(String varName, String defaultValue) {
        return Environment.getOrDefault(varName, String::toString, defaultValue);
    }

    private static <T> T getOrDefault(String var, Function<String, T> converter, T defaultValue) {
        String value = System.getenv(var) != null ? System.getenv(var) : (Objects.requireNonNull(JSON_DATA).get(var) != null ? JSON_DATA.get(var).asText() : null);
        T returnValue = defaultValue;
        if (value != null) {
            returnValue = converter.apply(value);
        }
        VALUES.put(var, String.valueOf(returnValue));
        return returnValue;
    }

    private static JsonNode loadConfigurationFile() {
        config = System.getenv().getOrDefault(CONFIG_FILE_PATH_ENVAR, Paths.get(System.getProperty("user.dir"), "config.json").toAbsolutePath().toString());
        ObjectMapper mapper = new ObjectMapper();
        try {
            File jsonFile = new File(config).getAbsoluteFile();
            return mapper.readTree(jsonFile);
        }
        catch (IOException ex) {
            LOGGER.info("Json configuration not provider or not exists");
            return mapper.createObjectNode();
        }
    }

    static {
        SYSTEM_TEST_STRIMZI_IMAGE_PULL_SECRET = Environment.getOrDefault(STRIMZI_IMAGE_PULL_SECRET_ENV, "");
        STRIMZI_ORG = Environment.getOrDefault(STRIMZI_ORG_ENV, STRIMZI_ORG_DEFAULT);
        STRIMZI_TAG = Environment.getOrDefault(STRIMZI_TAG_ENV, STRIMZI_TAG_DEFAULT);
        STRIMZI_REGISTRY = Environment.getOrDefault(STRIMZI_REGISTRY_ENV, STRIMZI_REGISTRY_DEFAULT);
        TEST_LOG_DIR = Environment.getOrDefault(TEST_LOG_DIR_ENV, TEST_LOG_DIR_DEFAULT);
        ST_KAFKA_VERSION = Environment.getOrDefault(ST_KAFKA_VERSION_ENV, ST_KAFKA_VERSION_DEFAULT);
        STRIMZI_LOG_LEVEL = Environment.getOrDefault(STRIMZI_LOG_LEVEL_ENV, STRIMZI_LOG_LEVEL_DEFAULT);
        KUBERNETES_DOMAIN = Environment.getOrDefault(KUBERNETES_DOMAIN_ENV, KUBERNETES_DOMAIN_DEFAULT);
        SKIP_TEARDOWN = Environment.getOrDefault(SKIP_TEARDOWN_ENV, Boolean::parseBoolean, false);
        STRIMZI_RBAC_SCOPE = Environment.getOrDefault(STRIMZI_RBAC_SCOPE_ENV, "CLUSTER");
        TEST_CLIENT_IMAGE_DEFAULT = STRIMZI_REGISTRY + "/" + STRIMZI_ORG + "/test-client:" + STRIMZI_TAG + "-kafka-" + ST_KAFKA_VERSION;
        TEST_CLIENT_IMAGE = Environment.getOrDefault(TEST_CLIENT_IMAGE_ENV, TEST_CLIENT_IMAGE_DEFAULT);
        BRIDGE_IMAGE = Environment.getOrDefault(BRIDGE_IMAGE_ENV, BRIDGE_IMAGE_DEFAULT);
        COMPONENTS_IMAGE_PULL_POLICY = Environment.getOrDefault(COMPONENTS_IMAGE_PULL_POLICY_ENV, COMPONENTS_IMAGE_PULL_POLICY_ENV_DEFAULT);
        OPERATOR_IMAGE_PULL_POLICY = Environment.getOrDefault(OPERATOR_IMAGE_PULL_POLICY_ENV, OPERATOR_IMAGE_PULL_POLICY_ENV_DEFAULT);
        OLM_OPERATOR_NAME = Environment.getOrDefault(OLM_OPERATOR_NAME_ENV, OLM_OPERATOR_NAME_DEFAULT);
        OLM_OPERATOR_DEPLOYMENT_NAME = Environment.getOrDefault(OLM_OPERATOR_DEPLOYMENT_NAME_ENV, "strimzi-cluster-operator");
        OLM_SOURCE_NAME = Environment.getOrDefault(OLM_SOURCE_NAME_ENV, OLM_SOURCE_NAME_DEFAULT);
        OLM_SOURCE_NAMESPACE = Environment.getOrDefault(OLM_SOURCE_NAMESPACE_ENV, "openshift-marketplace");
        OLM_APP_BUNDLE_PREFIX = Environment.getOrDefault(OLM_APP_BUNDLE_PREFIX_ENV, "strimzi-cluster-operator");
        OLM_OPERATOR_LATEST_RELEASE_VERSION = Environment.getOrDefault(OLM_OPERATOR_VERSION_ENV, OLM_OPERATOR_VERSION_DEFAULT);
        DEFAULT_TO_DENY_NETWORK_POLICIES = Environment.getOrDefault(DEFAULT_TO_DENY_NETWORK_POLICIES_ENV, Boolean::parseBoolean, true);
        CLUSTER_OPERATOR_INSTALL_TYPE = Environment.getOrDefault(CLUSTER_OPERATOR_INSTALL_TYPE_ENV, value -> ClusterOperatorInstallType.valueOf(value.toUpperCase(Locale.ENGLISH)), CLUSTER_OPERATOR_INSTALL_TYPE_DEFAULT);
        String debugFormat = "{}: {}";
        LOGGER.info("Used environment variables:");
        LOGGER.info(debugFormat, (Object)"CONFIG", (Object)config);
        VALUES.forEach((key, value) -> LOGGER.info(debugFormat, key, value));
    }
}

