/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.operator;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.OlmInstallationStrategy;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentUtils;
import io.strimzi.systemtest.utils.specific.OlmUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.executor.Exec;
import io.strimzi.test.k8s.KubeClusterResource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlmResource {
    private static final Logger LOGGER = LogManager.getLogger(OlmResource.class);
    public static final String NO_MORE_NON_USED_INSTALL_PLANS = "NoMoreNonUsedInstallPlans";
    private static final Map<String, Boolean> CLOSED_MAP_INSTALL_PLAN = new HashMap<String, Boolean>(3);
    private static Map<String, JsonObject> exampleResources = new HashMap<String, JsonObject>();

    public static void clusterOperator(String namespace) {
        OlmResource.clusterOperator(namespace, Constants.CO_OPERATION_TIMEOUT_DEFAULT, Constants.RECONCILIATION_INTERVAL, OlmInstallationStrategy.Automatic, null);
    }

    public static void clusterOperator(String namespace, OlmInstallationStrategy olmInstallationStrategy, String fromVersion) {
        OlmResource.clusterOperator(namespace, Constants.CO_OPERATION_TIMEOUT_DEFAULT, Constants.RECONCILIATION_INTERVAL, olmInstallationStrategy, fromVersion);
    }

    public static void clusterOperator(String namespace, long operationTimeout, long reconciliationInterval) {
        OlmResource.clusterOperator(namespace, operationTimeout, reconciliationInterval, OlmInstallationStrategy.Automatic, null);
    }

    public static void clusterOperator(String namespace, long operationTimeout, long reconciliationInterval, OlmInstallationStrategy olmInstallationStrategy, String fromVersion) {
        String csvName;
        if (!KubeClusterResource.getInstance().getDefaultOlmNamespace().equals(namespace)) {
            OlmResource.createOperatorGroup(namespace);
        }
        if (fromVersion != null) {
            OlmResource.createAndModifySubscription(namespace, operationTimeout, reconciliationInterval, olmInstallationStrategy, fromVersion);
            csvName = Environment.OLM_APP_BUNDLE_PREFIX + "." + fromVersion;
        } else {
            OlmResource.createAndModifySubscriptionLatestRelease(namespace, operationTimeout, reconciliationInterval, olmInstallationStrategy);
            csvName = Environment.OLM_APP_BUNDLE_PREFIX + "." + Environment.OLM_OPERATOR_LATEST_RELEASE_VERSION;
        }
        if (olmInstallationStrategy == OlmInstallationStrategy.Manual) {
            OlmUtils.waitUntilNonUsedInstallPlanIsPresent(fromVersion);
            OlmResource.obtainInstallPlanName();
            OlmResource.approveNonUsedInstallPlan();
        }
        TestUtils.waitFor((String)"Cluster Operator deployment creation", (long)Constants.GLOBAL_POLL_INTERVAL, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> ResourceManager.kubeClient().getDeploymentNameByPrefix(Environment.OLM_OPERATOR_DEPLOYMENT_NAME) != null);
        String deploymentName = ResourceManager.kubeClient().getDeploymentNameByPrefix(Environment.OLM_OPERATOR_DEPLOYMENT_NAME);
        ResourceManager.setCoDeploymentName(deploymentName);
        ResourceManager.getPointerResources().push(() -> OlmResource.deleteOlm(deploymentName, namespace, csvName));
        OlmResource.waitFor(deploymentName, namespace, 1);
        exampleResources = OlmResource.parseExamplesFromCsv(csvName, namespace);
    }

    public static void obtainInstallPlanName() {
        String[] installPlansLines;
        String installPlansPureString = KubeClusterResource.cmdKubeClient().execInCurrentNamespace(new String[]{"get", "installplan"}).out();
        for (String line : installPlansLines = installPlansPureString.split("\n")) {
            String[] wholeLine = line.split(" ");
            if (!wholeLine[0].startsWith("install-") || CLOSED_MAP_INSTALL_PLAN.containsKey(wholeLine[0])) continue;
            LOGGER.info("CLOSED_MAP_INSTALL_PLAN does not contain {} install plan so this is not used and will be in the following upgrade.", (Object)wholeLine[0]);
            CLOSED_MAP_INSTALL_PLAN.put(wholeLine[0], Boolean.FALSE);
        }
        if (CLOSED_MAP_INSTALL_PLAN.keySet().size() <= 0) {
            throw new RuntimeException("No install plans located in namespace:" + KubeClusterResource.cmdKubeClient().namespace());
        }
    }

    public static String getClusterOperatorVersion() {
        String[] installPlansLines;
        String installPlansPureString = KubeClusterResource.cmdKubeClient().execInCurrentNamespace(new String[]{"get", "installplan"}).out();
        for (String line : installPlansLines = installPlansPureString.split("\n")) {
            String[] wholeLine = line.split("   ");
            if (!wholeLine[0].equals(OlmResource.getNonUsedInstallPlan())) continue;
            return wholeLine[1];
        }
        throw new RuntimeException("Version was not found in the install plan.");
    }

    public static String getNonUsedInstallPlan() {
        String[] nonUsedInstallPlan = new String[1];
        for (Map.Entry<String, Boolean> entry : CLOSED_MAP_INSTALL_PLAN.entrySet()) {
            if (!entry.getValue().booleanValue()) {
                nonUsedInstallPlan[0] = entry.getKey();
                break;
            }
            nonUsedInstallPlan[0] = NO_MORE_NON_USED_INSTALL_PLANS;
        }
        LOGGER.info("Non-used install plan is {}", (Object)nonUsedInstallPlan[0]);
        return nonUsedInstallPlan[0];
    }

    private static void approveNonUsedInstallPlan() {
        String nonUsedInstallPlan = OlmResource.getNonUsedInstallPlan();
        try {
            LOGGER.info("Approving {} install plan", (Object)nonUsedInstallPlan);
            String dynamicScriptContent = "#!/bin/bash\n" + KubeClusterResource.cmdKubeClient().cmd() + " patch installplan " + nonUsedInstallPlan + " --type json  --patch '[{\"op\": \"add\", \"path\": \"/spec/approved\", \"value\": true}]' -n " + KubeClusterResource.getInstance().getNamespace();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(dynamicScriptContent.getBytes(Charset.defaultCharset()));
            File patchScript = File.createTempFile("installplan_patch", ".sh");
            Files.copy(inputStream, patchScript.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Exec.exec((String[])new String[]{"bash", patchScript.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void upgradeClusterOperator() {
        if (KubeClusterResource.kubeClient().listPodsByPrefixInName(ResourceManager.getCoDeploymentName()).size() == 0) {
            throw new RuntimeException("We can not perform upgrade! Cluster operator pod is not present.");
        }
        OlmResource.obtainInstallPlanName();
        OlmResource.approveNonUsedInstallPlan();
    }

    private static void createOperatorGroup(String namespace) {
        try {
            File operatorGroupFile = File.createTempFile("operatorgroup", ".yaml");
            InputStream groupInputStream = OlmResource.class.getClassLoader().getResourceAsStream("olm/operator-group.yaml");
            String operatorGroup = TestUtils.readResource((InputStream)groupInputStream);
            TestUtils.writeFile((String)operatorGroupFile.getAbsolutePath(), (String)operatorGroup.replace("${OPERATOR_NAMESPACE}", namespace));
            ResourceManager.cmdKubeClient().apply(new File[]{operatorGroupFile});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createAndModifySubscription(String namespace, long reconciliationInterval, long operationTimeout, OlmInstallationStrategy installationStrategy, String version) {
        try {
            File subscriptionFile = File.createTempFile("subscription", ".yaml");
            InputStream subscriptionInputStream = OlmResource.class.getClassLoader().getResourceAsStream("olm/subscription.yaml");
            String subscription = TestUtils.readResource((InputStream)subscriptionInputStream);
            TestUtils.writeFile((String)subscriptionFile.getAbsolutePath(), (String)subscription.replace("${OPERATOR_NAMESPACE}", namespace).replace("${OLM_OPERATOR_NAME}", Environment.OLM_OPERATOR_NAME).replace("${OLM_SOURCE_NAME}", Environment.OLM_SOURCE_NAME).replace("${OLM_SOURCE_NAMESPACE}", Environment.OLM_SOURCE_NAMESPACE).replace("${OLM_APP_BUNDLE_PREFIX}", Environment.OLM_APP_BUNDLE_PREFIX).replace("${OLM_OPERATOR_VERSION}", version).replace("${OLM_INSTALL_PLAN_APPROVAL}", installationStrategy.toString()).replace("${STRIMZI_FULL_RECONCILIATION_INTERVAL_MS}", Long.toString(reconciliationInterval)).replace("${STRIMZI_OPERATION_TIMEOUT_MS}", Long.toString(operationTimeout)).replace("${STRIMZI_RBAC_SCOPE}", Environment.STRIMZI_RBAC_SCOPE));
            ResourceManager.cmdKubeClient().apply(new File[]{subscriptionFile});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createAndModifySubscriptionLatestRelease(String namespace, long reconciliationInterval, long operationTimeout, OlmInstallationStrategy installationStrategy) {
        OlmResource.createAndModifySubscription(namespace, reconciliationInterval, operationTimeout, installationStrategy, Environment.OLM_OPERATOR_LATEST_RELEASE_VERSION);
    }

    public static void deleteOlm(String deploymentName, String namespace, String csvName) {
        ResourceManager.cmdKubeClient().exec(new String[]{"delete", "subscriptions", "-l", "app=strimzi", "-n", namespace});
        ResourceManager.cmdKubeClient().exec(new String[]{"delete", "operatorgroups", "-l", "app=strimzi", "-n", namespace});
        ResourceManager.cmdKubeClient().exec(false, new String[]{"delete", "csv", csvName, "-n", namespace});
        DeploymentUtils.waitForDeploymentDeletion(deploymentName);
    }

    private static void waitFor(String deploymentName, String namespace, int replicas) {
        LOGGER.info("Waiting for deployment {} in namespace {}", (Object)deploymentName, (Object)namespace);
        DeploymentUtils.waitForDeploymentAndPodsReady(deploymentName, replicas);
        LOGGER.info("Deployment {} in namespace {} is ready", (Object)deploymentName, (Object)namespace);
    }

    private static Map<String, JsonObject> parseExamplesFromCsv(String csvName, String namespace) {
        String csvString = ResourceManager.cmdKubeClient().exec(true, false, new String[]{"get", "csv", csvName, "-o", "json", "-n", namespace}).out();
        JsonObject csv = new JsonObject(csvString);
        String almExamples = csv.getJsonObject("metadata").getJsonObject("annotations").getString("alm-examples");
        JsonArray examples = new JsonArray(almExamples);
        return examples.stream().map(o -> (JsonObject)o).collect(Collectors.toMap(object -> object.getString("kind"), object -> object));
    }

    public static Map<String, JsonObject> getExampleResources() {
        return exampleResources;
    }

    public static void setExampleResources(Map<String, JsonObject> exampleResources) {
        OlmResource.exampleResources = exampleResources;
    }

    public static Map<String, Boolean> getClosedMapInstallPlan() {
        return CLOSED_MAP_INSTALL_PLAN;
    }
}

