/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.KafkaConnectS2IResource;
import io.strimzi.test.k8s.KubeClusterResource;

public class KafkaConnectS2IUtils {
    private KafkaConnectS2IUtils() {
    }

    public static void waitForConnectS2IStatus(String clusterName, Enum<?> status) {
        KafkaConnectS2I kafkaConnectS2I = (KafkaConnectS2I)((Resource)((NonNamespaceOperation)KafkaConnectS2IResource.kafkaConnectS2IClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get();
        ResourceManager.waitForResourceStatus(KafkaConnectS2IResource.kafkaConnectS2IClient(), kafkaConnectS2I, status);
    }

    public static void waitForConnectS2IReady(String clusterName) {
        KafkaConnectS2IUtils.waitForConnectS2IStatus(clusterName, CustomResourceStatus.Ready);
    }

    public static void waitForConnectS2INotReady(String clusterName) {
        KafkaConnectS2IUtils.waitForConnectS2IStatus(clusterName, CustomResourceStatus.NotReady);
    }
}

