/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.objects;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PodUtils {
    private static final Logger LOGGER = LogManager.getLogger(PodUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion("Pod");
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("Pod");

    private PodUtils() {
    }

    public static Map<String, String> podSnapshot(LabelSelector selector) {
        List pods = KubeClusterResource.kubeClient().listPods(selector);
        return pods.stream().collect(Collectors.toMap(pod -> pod.getMetadata().getName(), pod -> pod.getMetadata().getUid()));
    }

    public static String getFirstContainerImageNameFromPod(String podName) {
        return ((Container)KubeClusterResource.kubeClient().getPod(podName).getSpec().getContainers().get(0)).getImage();
    }

    public static String getContainerImageNameFromPod(String podName, String containerName) {
        return KubeClusterResource.kubeClient().getPod(podName).getSpec().getContainers().stream().filter(c -> c.getName().equals(containerName)).findFirst().get().getImage();
    }

    public static String getInitContainerImageName(String podName) {
        return ((Container)KubeClusterResource.kubeClient().getPod(podName).getSpec().getInitContainers().get(0)).getImage();
    }

    public static void waitForPodsReady(LabelSelector selector, int expectPods, boolean containers) {
        PodUtils.waitForPodsReady(selector, expectPods, containers, () -> {});
    }

    public static void waitForPodsReady(LabelSelector selector, int expectPods, boolean containers, Runnable onTimeout) {
        int[] counter = new int[]{0};
        TestUtils.waitFor((String)("All pods matching " + selector + "to be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)ResourceOperation.timeoutForPodsOperation(expectPods), () -> {
            List pods = KubeClusterResource.kubeClient().listPods(selector);
            if (pods.isEmpty() && expectPods == 0) {
                LOGGER.debug("Expected pods are ready");
                return true;
            }
            if (pods.isEmpty()) {
                LOGGER.debug("Not ready (no pods matching {})", (Object)selector);
                return false;
            }
            if (pods.size() != expectPods) {
                LOGGER.debug("Expected pods {} are not ready", (Object)selector);
                return false;
            }
            for (Pod pod : pods) {
                if (!Readiness.isPodReady((Pod)pod)) {
                    LOGGER.debug("Not ready (at least 1 pod not ready: {})", (Object)pod.getMetadata().getName());
                    counter[0] = 0;
                    return false;
                }
                if (!containers) continue;
                for (ContainerStatus cs : pod.getStatus().getContainerStatuses()) {
                    LOGGER.debug("Not ready (at least 1 container of pod {} not ready: {})", (Object)pod.getMetadata().getName(), (Object)cs.getName());
                    if (Boolean.TRUE.equals(cs.getReady())) continue;
                    return false;
                }
            }
            LOGGER.debug("Pods {} are ready", (Object)pods.stream().map(p -> p.getMetadata().getName()).collect(Collectors.joining(", ")));
            counter[0] = counter[0] + 1;
            return counter[0] > 10;
        }, (Runnable)onTimeout);
    }

    public static void waitForPodUpdate(String podName, Date startTime) {
        TestUtils.waitFor((String)(podName + " update"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> startTime.before(KubeClusterResource.kubeClient().getCreationTimestampForPod(podName)));
    }

    public static void waitForPodsWithPrefixDeletion(String podsNamePrefix) {
        LOGGER.info("Waiting when all Pods with prefix {} will be deleted", (Object)podsNamePrefix);
        KubeClusterResource.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(podsNamePrefix)).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    public static String getPodNameByPrefix(String prefix) {
        return KubeClusterResource.kubeClient().listPods().stream().filter(pod -> pod.getMetadata().getName().startsWith(prefix)).findFirst().get().getMetadata().getName();
    }

    public static String getFirstPodNameContaining(String searchTerm) {
        return KubeClusterResource.kubeClient().listPods().stream().filter(pod -> pod.getMetadata().getName().contains(searchTerm)).findFirst().get().getMetadata().getName();
    }

    public static void waitForPod(String name) {
        LOGGER.info("Waiting when Pod {} will be ready", (Object)name);
        TestUtils.waitFor((String)("pod " + name + " to be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)ResourceOperation.timeoutForPodsOperation(1), () -> {
            List statuses = KubeClusterResource.kubeClient().getPod(name).getStatus().getContainerStatuses();
            for (ContainerStatus containerStatus : statuses) {
                if (containerStatus.getReady().booleanValue()) continue;
                return false;
            }
            return true;
        });
        LOGGER.info("Pod {} is ready", (Object)name);
    }

    public static void deletePodWithWait(String name) {
        LOGGER.info("Waiting when Pod {} will be deleted", (Object)name);
        TestUtils.waitFor((String)("Pod " + name + " could not be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            List pods = KubeClusterResource.kubeClient().listPodsByPrefixInName(name);
            if (pods.size() != 0) {
                for (Pod pod : pods) {
                    if (!pod.getStatus().getPhase().equals("Terminating")) continue;
                    LOGGER.debug("Deleting pod {}", (Object)pod.getMetadata().getName());
                    KubeClusterResource.cmdKubeClient().deleteByName("pod", pod.getMetadata().getName());
                }
                return false;
            }
            return true;
        });
        LOGGER.info("Pod {} deleted", (Object)name);
    }

    public static void waitUntilPodsCountIsPresent(String podNamePrefix, int numberOfPods) {
        LOGGER.info("Wait until {} Pods with prefix {} are present", (Object)numberOfPods, (Object)podNamePrefix);
        TestUtils.waitFor((String)"", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> KubeClusterResource.kubeClient().listPodsByPrefixInName(podNamePrefix).size() == numberOfPods);
        LOGGER.info("Pods with count {} are present", (Object)numberOfPods);
    }

    public static void waitUntilMessageIsInPodLogs(String podName, String message) {
        LOGGER.info("Waiting for message will be in the log");
        TestUtils.waitFor((String)"Waiting for message will be in the log", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.TIMEOUT_FOR_LOG, () -> KubeClusterResource.kubeClient().logs(podName).contains(message));
        LOGGER.info("Message {} found in {} log", (Object)message, (Object)podName);
    }

    public static void waitUntilMessageIsInLogs(String podName, String containerName, String message) {
        LOGGER.info("Waiting for message will be in the log");
        TestUtils.waitFor((String)"Waiting for message will be in the log", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.TIMEOUT_FOR_LOG, () -> KubeClusterResource.kubeClient().logs(podName, containerName).contains(message));
        LOGGER.info("Message {} found in {}:{} log", (Object)message, (Object)podName, (Object)containerName);
    }

    public static void waitUntilPodContainersCount(String podNamePrefix, int numberOfContainers) {
        LOGGER.info("Wait until Pod {} will have {} containers", (Object)podNamePrefix, (Object)numberOfContainers);
        TestUtils.waitFor((String)("Pod " + podNamePrefix + " will have " + numberOfContainers + " containers"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> ((Pod)KubeClusterResource.kubeClient().listPodsByPrefixInName(podNamePrefix).get(0)).getSpec().getContainers().size() == numberOfContainers);
        LOGGER.info("Pod {} has {} containers", (Object)podNamePrefix, (Object)numberOfContainers);
    }

    public static void waitUntilPodStabilityReplicasCount(String podNamePrefix, int expectedPods) {
        LOGGER.info("Wait until Pod {} will have stable {} replicas", (Object)podNamePrefix, (Object)expectedPods);
        int[] stableCounter = new int[]{0};
        TestUtils.waitFor((String)("Pod" + podNamePrefix + " will have " + expectedPods + " replicas"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> {
            if (KubeClusterResource.kubeClient().listPodsByPrefixInName(podNamePrefix).size() == expectedPods) {
                stableCounter[0] = stableCounter[0] + 1;
                if (stableCounter[0] == 20) {
                    LOGGER.info("Pod replicas are stable for {} polls intervals", (Object)stableCounter[0]);
                    return true;
                }
            } else {
                LOGGER.info("Pod replicas are not stable. Going to set the counter to zero.");
                stableCounter[0] = 0;
                return false;
            }
            LOGGER.info("Pod replicas gonna be stable in {} polls", (Object)(20 - stableCounter[0]));
            return false;
        });
        LOGGER.info("Pod {} has {} replicas", (Object)podNamePrefix, (Object)expectedPods);
    }

    public static void waitUntilPodIsInCrashLoopBackOff(String podName) {
        LOGGER.info("Wait until Pod {} is in CrashLoopBackOff state", (Object)podName);
        TestUtils.waitFor((String)"Pod {} is in CrashLoopBackOff state", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> ((ContainerStatus)KubeClusterResource.kubeClient().getPod(podName).getStatus().getContainerStatuses().get(0)).getState().getWaiting().getReason().equals("CrashLoopBackOff"));
        LOGGER.info("Pod {} is in CrashLoopBackOff state", (Object)podName);
    }

    public static void waitUntilPodIsPresent(String podNamePrefix) {
        LOGGER.info("Wait until Pod {} is present", (Object)podNamePrefix);
        TestUtils.waitFor((String)"Pod is present", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> KubeClusterResource.kubeClient().listPodsByPrefixInName(podNamePrefix).get(0) != null);
        LOGGER.info("Pod {} is present", (Object)podNamePrefix);
    }

    public static void waitUntilPodIsInPendingStatus(String podName) {
        LOGGER.info("Wait until Pod {} is in pending state", (Object)podName);
        TestUtils.waitFor((String)("Pod " + podName + " is in pending state"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> KubeClusterResource.kubeClient().getPod(podName).getStatus().getPhase().equals("Pending"));
        LOGGER.info("Pod:" + podName + " is in pending status");
    }

    public static void waitUntilPodLabelsDeletion(String podName, String ... labelKeys) {
        for (String labelKey : labelKeys) {
            LOGGER.info("Waiting for Pod label {} change to {}", (Object)labelKey, null);
            TestUtils.waitFor((String)("Pod label" + labelKey + " change to null"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getPod(podName).getMetadata().getLabels().get(labelKey) == null);
            LOGGER.info("Pod label {} changed to {}", (Object)labelKey, null);
        }
    }

    public static void waitForPendingPod(String podPrefix) {
        LOGGER.info("Wait for at least one pod with prefix: {} will be in pending phase", (Object)podPrefix);
        TestUtils.waitFor((String)"One pod to be in PENDING state", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            List actualPods = KubeClusterResource.kubeClient().listPodsByPrefixInName(podPrefix);
            return actualPods.stream().anyMatch(pod -> pod.getStatus().getPhase().equals("Pending"));
        });
    }

    public static void verifyThatRunningPodsAreStable(String podPrefix) {
        LOGGER.info("Verify that all pods with prefix: {} are stable", (Object)podPrefix);
        PodUtils.verifyThatPodsAreStable(podPrefix, "Running");
    }

    public static void verifyThatPendingPodsAreStable(String podPrefix) {
        LOGGER.info("Verify that all pods with prefix: {} are stable in pending phase", (Object)podPrefix);
        PodUtils.verifyThatPodsAreStable(podPrefix, "Pending");
    }

    private static void verifyThatPodsAreStable(String podPrefix, String phase) {
        int[] stabilityCounter = new int[]{0};
        List runningPods = KubeClusterResource.kubeClient().listPodsByPrefixInName(podPrefix).stream().filter(pod -> pod.getStatus().getPhase().equals(phase)).collect(Collectors.toList());
        TestUtils.waitFor((String)String.format("Pods stability in phase %s", phase), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            List actualPods = runningPods.stream().map(p -> KubeClusterResource.kubeClient().getPod(p.getMetadata().getName())).collect(Collectors.toList());
            for (Pod pod : actualPods) {
                if (pod.getStatus().getPhase().equals(phase)) {
                    LOGGER.info("Pod {} is in the {} state. Remaining seconds pod to be stable {}", (Object)pod.getMetadata().getName(), (Object)pod.getStatus().getPhase(), (Object)(Constants.GLOBAL_RECONCILIATION_COUNT - stabilityCounter[0]));
                    continue;
                }
                LOGGER.info("Pod {} is not stable in phase following phase {} reset the stability counter from {} to {}", (Object)pod.getMetadata().getName(), (Object)pod.getStatus().getPhase(), (Object)stabilityCounter[0], (Object)0);
                stabilityCounter[0] = 0;
                return false;
            }
            stabilityCounter[0] = stabilityCounter[0] + 1;
            if (stabilityCounter[0] == Constants.GLOBAL_RECONCILIATION_COUNT) {
                LOGGER.info("All pods are stable {}", (Object)actualPods.stream().map(p -> p.getMetadata().getName()).collect(Collectors.joining(" ,")));
                return true;
            }
            return false;
        });
    }

    public static void waitForPodContainerReady(String podName, String containerName) {
        LOGGER.info("Waiting for Pod {} container {} will be ready", (Object)podName, (Object)containerName);
        TestUtils.waitFor((String)("Pod " + podName + " container " + containerName + "will be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> KubeClusterResource.kubeClient().getPod(podName).getStatus().getContainerStatuses().stream().filter(container -> container.getName().equals(containerName)).findFirst().get().getReady());
        LOGGER.info("Pod {} container {} is ready", (Object)podName, (Object)containerName);
    }
}

