/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.objects;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger(ServiceUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("Service");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private ServiceUtils() {
    }

    public static void waitForServiceLabelsChange(String serviceName, Map<String, String> labels) {
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            boolean isK8sTag;
            boolean bl = isK8sTag = entry.getKey().equals("controller-revision-hash") || entry.getKey().equals("statefulset.kubernetes.io/pod-name");
            boolean isStrimziTag = entry.getKey().startsWith("strimzi.io/");
            if (isStrimziTag || isK8sTag) continue;
            LOGGER.info("Waiting for Service label change {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
            TestUtils.waitFor((String)("Service label change " + entry.getKey() + " -> " + entry.getValue()), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> ((String)KubeClusterResource.kubeClient().getService(serviceName).getMetadata().getLabels().get(entry.getKey())).equals(entry.getValue()));
        }
    }

    public static void waitForServiceLabelsDeletion(String serviceName, String ... labelKeys) {
        for (String labelKey : labelKeys) {
            LOGGER.info("Service label {} change to {}", (Object)labelKey, null);
            TestUtils.waitFor((String)("Service label" + labelKey + " change to null"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getService(serviceName).getMetadata().getLabels().get(labelKey) == null);
        }
    }

    public static void waitForLoadBalancerService(String serviceName) {
        LOGGER.info("Waiting for Service {} in namespace {}", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("LoadBalancer service " + serviceName + " to be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> ((Service)((ServiceResource)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().services().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(serviceName)).get()).getSpec().getExternalIPs().size() > 0);
        LOGGER.info("Service {} in namespace {} is ready", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
    }

    public static void waitForNodePortService(String serviceName) throws InterruptedException {
        LOGGER.info("Waiting for Service {} in namespace {}", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("NodePort service " + serviceName + " to be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> ((ServicePort)((Service)((ServiceResource)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().services().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(serviceName)).get()).getSpec().getPorts().get(0)).getNodePort() != null);
        Thread.sleep(10000L);
        LOGGER.info("Service {} in namespace {} is ready", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
    }

    public static void waitForServiceDeletion(String serviceName) {
        LOGGER.info("Waiting for Service {} deletion in namespace {}", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("Service " + serviceName + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getService(serviceName) == null);
        LOGGER.info("Service {} in namespace {} was deleted", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
    }

    public static void waitForServiceRecovery(String serviceName, String serviceUid) {
        LOGGER.info("Waiting when Service {}-{} in namespace {} will be recovered", (Object)serviceName, (Object)serviceUid, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("Service " + serviceName + " to be recovered"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.TIMEOUT_FOR_RESOURCE_RECOVERY, () -> !KubeClusterResource.kubeClient().getServiceUid(serviceName).equals(serviceUid));
        LOGGER.info("{} in namespace {} is recovered", (Object)serviceName, (Object)KubeClusterResource.kubeClient().getNamespace());
    }

    public static void waitUntilAddressIsReachable(String address) {
        LOGGER.info("Wait until address {} is reachable", (Object)address);
        TestUtils.waitFor((String)"", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> {
            try {
                InetAddress.getByName(address);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        });
        LOGGER.info("Address {} is reachable", (Object)address);
    }
}

