/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.specific;

import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.executor.Exec;
import io.strimzi.test.executor.ExecResult;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakUtils {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakUtils.class);
    public static final String PATH_TO_KEYCLOAK_PREPARE_SCRIPT = "../systemtest/src/test/resources/oauth2/prepare_keycloak_operator.sh";
    public static final String PATH_TO_KEYCLOAK_TEARDOWN_SCRIPT = "../systemtest/src/test/resources/oauth2/teardown_keycloak_operator.sh";

    private KeycloakUtils() {
    }

    public static void deployKeycloak(String namespace) {
        LOGGER.info("Prepare Keycloak in namespace: {}", (Object)namespace);
        ResourceManager.getPointerResources().push(() -> KeycloakUtils.deleteKeycloak(namespace));
        ExecResult result = Exec.exec((boolean)true, (String[])new String[]{"/bin/bash", PATH_TO_KEYCLOAK_PREPARE_SCRIPT, namespace});
        if (!result.out().contains("All realms were successfully imported")) {
            LOGGER.info("Errors occurred during Keycloak install: {}", (Object)result.err());
            throw new RuntimeException("Keycloak wasn't deployed correctly!");
        }
        LOGGER.info("Keycloak in namespace {} is ready", (Object)namespace);
    }

    public static void deleteKeycloak(String namespace) {
        LOGGER.info("Teardown Keycloak in namespace: {}", (Object)namespace);
        Exec.exec((boolean)true, (String[])new String[]{"/bin/bash", PATH_TO_KEYCLOAK_TEARDOWN_SCRIPT, namespace});
    }

    public static String getToken(String baseURI, String userName, String password) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return new JsonObject(ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "POST", "-d", "client_id=admin-cli&client_secret=aGVsbG8td29ybGQtcHJvZHVjZXItc2VjcmV0&grant_type=password&username=" + userName + "&password=" + password, baseURI + "/auth/realms/master/protocol/openid-connect/token"}).out()).getString("access_token");
    }

    public static JsonObject getKeycloakRealm(String baseURI, String token, String desiredRealm) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return new JsonObject(ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "GET", baseURI + "/auth/admin/realms/" + desiredRealm, "-H", "Authorization: Bearer " + token}).out());
    }

    public static JsonArray getKeycloakRealmClients(String baseURI, String token, String desiredRealm) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return new JsonArray(ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "GET", baseURI + "/auth/admin/realms/" + desiredRealm + "/clients", "-H", "Authorization: Bearer " + token}).out());
    }

    public static JsonArray getResourcesFromRealmClient(String baseURI, String token, String desiredRealm, String clientId) {
        return KeycloakUtils.getConfigFromResourceServerOfRealm(baseURI, token, desiredRealm, clientId, "resource");
    }

    public static JsonArray getPoliciesFromRealmClient(String baseURI, String token, String desiredRealm, String clientId) {
        return KeycloakUtils.getConfigFromResourceServerOfRealm(baseURI, token, desiredRealm, clientId, "policy");
    }

    private static JsonArray getConfigFromResourceServerOfRealm(String baseURI, String token, String desiredRealm, String clientId, String endpoint) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return new JsonArray(ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "GET", baseURI + "/auth/admin/realms/" + desiredRealm + "/clients/" + clientId + "/authz/resource-server/" + endpoint, "-H", "Authorization: Bearer " + token}).out());
    }

    public static String putConfigurationToRealm(String baseURI, String token, JsonObject config, String desiredRealm) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "PUT", baseURI + "/auth/admin/realms/" + desiredRealm, "-H", "Authorization: Bearer " + token, "-d", config.toString(), "-H", "Content-Type: application/json"}).out();
    }

    public static String updatePolicyOfRealmClient(String baseURI, String token, JsonObject policy, String desiredRealm, String clientId) {
        String coPodName = ResourceManager.kubeClient().getClusterOperatorPodName();
        return ResourceManager.cmdKubeClient().execInPod(coPodName, new String[]{"curl", "-v", "--insecure", "-X", "PUT", baseURI + "/auth/admin/realms/" + desiredRealm + "/clients/" + clientId + "/authz/resource-server/policy/" + policy.getValue("id"), "-H", "Authorization: Bearer " + token, "-d", policy.toString(), "-H", "Content-Type: application/json"}).out();
    }
}

