/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.common;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.verifyica.pipeliner.common.MessageSupplier;
import org.verifyica.pipeliner.common.ValidatorException;

public class Validator {
    private static final String PROPERTY_MATCHING_REGEX = "(?<!\\\\)\\$\\{\\{\\s*([a-zA-Z0-9_\\-.]+)\\s*\\}\\}";
    private final Pattern validIdPattern = Pattern.compile("^[a-zA-Z0-9-_]*$");
    private final Pattern validPropertyPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_.-]*$");
    private final Pattern validEnvironmentVariablePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");

    public Validator condition(boolean condition, String message) throws ValidatorException {
        return this.condition(condition, Validator.of(message));
    }

    public Validator condition(boolean condition, Supplier<String> messageSupplier) throws ValidatorException {
        if (!condition) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator notNull(Object object, String message) throws ValidatorException {
        return this.notNull(object, Validator.of(message));
    }

    public Validator notNull(Object object, Supplier<String> messageSupplier) throws ValidatorException {
        if (object == null) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator notBlank(String string, String message) throws ValidatorException {
        return this.notBlank(string, Validator.of(message));
    }

    public Validator notBlank(String string, Supplier<String> messageSupplier) throws ValidatorException {
        if (string.trim().isEmpty()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isBoolean(Object object, String message) throws ValidatorException {
        return this.isBoolean(object, Validator.of(message));
    }

    public Validator isBoolean(Object object, Supplier<String> messageSupplier) throws ValidatorException {
        String string;
        if (!(object instanceof String)) {
            throw new ValidatorException(messageSupplier.get());
        }
        switch (string = ((String)object).trim().toLowerCase(Locale.US)) {
            case "true": 
            case "yes": 
            case "y": 
            case "on": 
            case "1": 
            case "false": 
            case "no": 
            case "n": 
            case "off": 
            case "0": {
                break;
            }
            default: {
                throw new ValidatorException(messageSupplier.get());
            }
        }
        return this;
    }

    public Validator isString(Object object, String message) throws ValidatorException {
        return this.isString(object, Validator.of(message));
    }

    public Validator isString(Object object, Supplier<String> messageSupplier) throws ValidatorException {
        if (!(object instanceof String)) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isList(Object object, String message) throws ValidatorException {
        return this.isList(object, Validator.of(message));
    }

    public Validator isList(Object object, Supplier<String> messageSupplier) throws ValidatorException {
        try {
            List list = (List)object;
        }
        catch (ClassCastException e) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isMap(Object object, String message) throws ValidatorException {
        return this.isMap(object, Validator.of(message));
    }

    public Validator isMap(Object object, Supplier<String> messageSupplier) throws ValidatorException {
        try {
            Map map = (Map)object;
        }
        catch (ClassCastException c) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isValidId(String string, String message) throws ValidatorException {
        return this.isValidId(string, Validator.of(message));
    }

    public Validator isValidId(String string, Supplier<String> messageSupplier) throws ValidatorException {
        if (!this.validIdPattern.matcher(string.trim()).matches()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isValidProperty(String string, String message) throws ValidatorException {
        return this.isValidProperty(string, Validator.of(message));
    }

    public Validator isValidProperty(String string, Supplier<String> messageSupplier) throws ValidatorException {
        if (!this.validPropertyPattern.matcher(string.trim()).matches()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isValidEnvironmentVariable(String string, String message) throws ValidatorException {
        return this.isValidEnvironmentVariable(string, Validator.of(message));
    }

    public Validator isValidEnvironmentVariable(String string, Supplier<String> messageSupplier) throws ValidatorException {
        if (!this.validEnvironmentVariablePattern.matcher(string.trim()).matches()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isValidFile(File file, String message) throws ValidatorException {
        return this.isValidFile(file, Validator.of(message));
    }

    public Validator isValidFile(File file, Supplier<String> messageSupplier) throws ValidatorException {
        if (!file.exists()) {
            throw new ValidatorException(messageSupplier.get());
        }
        if (!file.isFile()) {
            throw new ValidatorException(messageSupplier.get());
        }
        if (!file.canRead()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator isValidDirectory(File directory, String message) throws ValidatorException {
        return this.isValidDirectory(directory, Validator.of(message));
    }

    public Validator isValidDirectory(File directory, Supplier<String> messageSupplier) throws ValidatorException {
        if (!directory.exists()) {
            throw new ValidatorException(messageSupplier.get());
        }
        if (!directory.isDirectory()) {
            throw new ValidatorException(messageSupplier.get());
        }
        if (!directory.canRead()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    public Validator propertiesAreResolved(String string, String message) throws ValidatorException {
        return this.propertiesAreResolved(string, Validator.of(message));
    }

    public Validator propertiesAreResolved(String string, MessageSupplier messageSupplier) throws ValidatorException {
        Pattern pattern = Pattern.compile(PROPERTY_MATCHING_REGEX);
        if (pattern.matcher(string).find()) {
            throw new ValidatorException(messageSupplier.get());
        }
        return this;
    }

    private static MessageSupplier of(String message) {
        return new MessageSupplier(message);
    }
}

