/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime.definition;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocumentParser
extends DefaultHandler {
    private static final String DTD_PUBLIC_ID = "-//AspectJ//DTD 1.5.0//EN";
    private static final String DTD_PUBLIC_ID_ALIAS = "-//AspectJ//DTD//EN";
    private static final String ASPECTJ_ELEMENT = "aspectj";
    private static final String WEAVER_ELEMENT = "weaver";
    private static final String DUMP_ELEMENT = "dump";
    private static final String DUMP_BEFOREANDAFTER_ATTRIBUTE = "beforeandafter";
    private static final String DUMP_PERCLASSLOADERDIR_ATTRIBUTE = "perclassloaderdumpdir";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String EXCLUDE_ELEMENT = "exclude";
    private static final String OPTIONS_ATTRIBUTE = "options";
    private static final String ASPECTS_ELEMENT = "aspects";
    private static final String ASPECT_ELEMENT = "aspect";
    private static final String CONCRETE_ASPECT_ELEMENT = "concrete-aspect";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String EXTEND_ATTRIBUTE = "extends";
    private static final String PRECEDENCE_ATTRIBUTE = "precedence";
    private static final String PERCLAUSE_ATTRIBUTE = "perclause";
    private static final String POINTCUT_ELEMENT = "pointcut";
    private static final String WITHIN_ATTRIBUTE = "within";
    private static final String EXPRESSION_ATTRIBUTE = "expression";
    private final Definition m_definition = new Definition();
    private boolean m_inAspectJ;
    private boolean m_inWeaver;
    private boolean m_inAspects;
    private Definition.ConcreteAspect m_lastConcreteAspect;

    private DocumentParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Definition parse(URL url) throws Exception {
        InputStream in = null;
        try {
            DocumentParser parser = new DocumentParser();
            XMLReader xmlReader = DocumentParser.getXMLReader();
            xmlReader.setContentHandler(parser);
            xmlReader.setErrorHandler(parser);
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            xmlReader.setEntityResolver(parser);
            in = url.openStream();
            xmlReader.parse(new InputSource(in));
            Definition definition = parser.m_definition;
            return definition;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
    }

    private static XMLReader getXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = null;
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException ex) {
            xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        return xmlReader;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId.equals(DTD_PUBLIC_ID) || publicId.equals(DTD_PUBLIC_ID_ALIAS)) {
            InputStream in = DocumentParser.class.getResourceAsStream("/aspectj_1_5_0.dtd");
            if (in == null) {
                System.err.println("AspectJ - WARN - could not read DTD " + publicId);
                return null;
            }
            return new InputSource(in);
        }
        System.err.println("AspectJ - WARN - unknown DTD " + publicId + " - consider using " + DTD_PUBLIC_ID);
        return null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ASPECT_ELEMENT.equals(qName)) {
            String name = attributes.getValue(NAME_ATTRIBUTE);
            String scopePattern = DocumentParser.replaceXmlAnd(attributes.getValue(SCOPE_ATTRIBUTE));
            if (!this.isNull(name)) {
                this.m_definition.getAspectClassNames().add(name);
                if (scopePattern != null) {
                    this.m_definition.addScopedAspect(name, scopePattern);
                }
            }
        } else if (WEAVER_ELEMENT.equals(qName)) {
            String options = attributes.getValue(OPTIONS_ATTRIBUTE);
            if (!this.isNull(options)) {
                this.m_definition.appendWeaverOptions(options);
            }
            this.m_inWeaver = true;
        } else if (CONCRETE_ASPECT_ELEMENT.equals(qName)) {
            String name = attributes.getValue(NAME_ATTRIBUTE);
            String extend = attributes.getValue(EXTEND_ATTRIBUTE);
            String precedence = attributes.getValue(PRECEDENCE_ATTRIBUTE);
            String perclause = attributes.getValue(PERCLAUSE_ATTRIBUTE);
            if (!this.isNull(name)) {
                this.m_lastConcreteAspect = new Definition.ConcreteAspect(name, extend, precedence, perclause);
                this.m_definition.getConcreteAspects().add(this.m_lastConcreteAspect);
            }
        } else if (POINTCUT_ELEMENT.equals(qName) && this.m_lastConcreteAspect != null) {
            String name = attributes.getValue(NAME_ATTRIBUTE);
            String expression = attributes.getValue(EXPRESSION_ATTRIBUTE);
            if (!this.isNull(name) && !this.isNull(expression)) {
                this.m_lastConcreteAspect.pointcuts.add(new Definition.Pointcut(name, DocumentParser.replaceXmlAnd(expression)));
            }
        } else if (ASPECTJ_ELEMENT.equals(qName)) {
            if (this.m_inAspectJ) {
                throw new SAXException("Found nested <aspectj> element");
            }
            this.m_inAspectJ = true;
        } else if (ASPECTS_ELEMENT.equals(qName)) {
            this.m_inAspects = true;
        } else if (INCLUDE_ELEMENT.equals(qName) && this.m_inWeaver) {
            String typePattern = this.getWithinAttribute(attributes);
            if (!this.isNull(typePattern)) {
                this.m_definition.getIncludePatterns().add(typePattern);
            }
        } else if (EXCLUDE_ELEMENT.equals(qName) && this.m_inWeaver) {
            String typePattern = this.getWithinAttribute(attributes);
            if (!this.isNull(typePattern)) {
                this.m_definition.getExcludePatterns().add(typePattern);
            }
        } else if (DUMP_ELEMENT.equals(qName) && this.m_inWeaver) {
            String perWeaverDumpDir;
            String beforeAndAfter;
            String typePattern = this.getWithinAttribute(attributes);
            if (!this.isNull(typePattern)) {
                this.m_definition.getDumpPatterns().add(typePattern);
            }
            if (this.isTrue(beforeAndAfter = attributes.getValue(DUMP_BEFOREANDAFTER_ATTRIBUTE))) {
                this.m_definition.setDumpBefore(true);
            }
            if (this.isTrue(perWeaverDumpDir = attributes.getValue(DUMP_PERCLASSLOADERDIR_ATTRIBUTE))) {
                this.m_definition.setCreateDumpDirPerClassloader(true);
            }
        } else if (EXCLUDE_ELEMENT.equals(qName) && this.m_inAspects) {
            String typePattern = this.getWithinAttribute(attributes);
            if (!this.isNull(typePattern)) {
                this.m_definition.getAspectExcludePatterns().add(typePattern);
            }
        } else if (INCLUDE_ELEMENT.equals(qName) && this.m_inAspects) {
            String typePattern = this.getWithinAttribute(attributes);
            if (!this.isNull(typePattern)) {
                this.m_definition.getAspectIncludePatterns().add(typePattern);
            }
        } else {
            throw new SAXException("Unknown element while parsing <aspectj> element: " + qName);
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private String getWithinAttribute(Attributes attributes) {
        return DocumentParser.replaceXmlAnd(attributes.getValue(WITHIN_ATTRIBUTE));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CONCRETE_ASPECT_ELEMENT.equals(qName)) {
            this.m_lastConcreteAspect = null;
        } else if (ASPECTJ_ELEMENT.equals(qName)) {
            this.m_inAspectJ = false;
        } else if (WEAVER_ELEMENT.equals(qName)) {
            this.m_inWeaver = false;
        } else if (ASPECTS_ELEMENT.equals(qName)) {
            this.m_inAspects = false;
        }
        super.endElement(uri, localName, qName);
    }

    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
    }

    public void error(SAXParseException e) throws SAXException {
        super.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        super.fatalError(e);
    }

    private static String replaceXmlAnd(String expression) {
        return LangUtil.replace(expression, " AND ", " && ");
    }

    private boolean isNull(String s) {
        return s == null || s.length() <= 0;
    }

    private boolean isTrue(String s) {
        return s != null && s.equals("true");
    }
}

