/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Channel;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

public class ChannelTest
implements Runnable {
    private Channel channel = null;
    private Thread mythread = null;
    private boolean looping = true;

    public void start() throws Exception {
        this.channel = new JChannel();
        this.channel.connect("ExampleGroup");
        this.mythread = new Thread(this);
        this.mythread.start();
        for (int i = 0; i < 30; ++i) {
            System.out.println("Casting msg #" + i);
            this.channel.send(new Message(null, null, (Serializable)((Object)("Msg #" + i))));
            Thread.sleep(1000L);
        }
        this.channel.disconnect();
        this.channel.close();
        this.looping = false;
        this.mythread.interrupt();
        this.mythread.join(1000L);
    }

    public void run() {
        while (this.looping) {
            try {
                Object obj = this.channel.receive(0L);
                if (obj instanceof View) {
                    System.out.println("--> NEW VIEW: " + obj);
                    continue;
                }
                if (!(obj instanceof Message)) continue;
                Message msg = (Message)obj;
                System.out.println("Received " + msg.getObject());
            }
            catch (ChannelNotConnectedException conn) {
                break;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            ChannelTest test = new ChannelTest();
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

