/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.UUID;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.reteoo.ReteooRuleBase;

public class RuleBaseFactory {
    private static final RuleBaseFactory INSTANCE = new RuleBaseFactory();

    private RuleBaseFactory() {
    }

    public static RuleBaseFactory getInstance() {
        return INSTANCE;
    }

    public static RuleBase newRuleBase() {
        return RuleBaseFactory.newRuleBase(1, null);
    }

    public static RuleBase newRuleBase(RuleBaseConfiguration config) {
        return RuleBaseFactory.newRuleBase(1, config);
    }

    public static RuleBase newRuleBase(int type) {
        return RuleBaseFactory.newRuleBase(type, null);
    }

    public static RuleBase newRuleBase(int type, RuleBaseConfiguration config) {
        switch (type) {
            case 1: {
                return new ReteooRuleBase(UUID.randomUUID().toString(), config);
            }
        }
        throw new IllegalArgumentException("Unknown engine type: " + type);
    }
}

