/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.spi.Activation;
import org.drools.util.BinaryHeapQueue;
import org.drools.util.Queueable;

public class BinaryHeapQueueAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 400L;
    private String name;
    private BinaryHeapQueue queue;
    private boolean active;

    public BinaryHeapQueueAgendaGroup() {
    }

    public BinaryHeapQueueAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        this.queue = new BinaryHeapQueue(ruleBase.getConfiguration().getConflictResolver());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.queue = (BinaryHeapQueue)in.readObject();
        this.active = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.queue);
        out.writeBoolean(this.active);
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    public void add(Activation activation) {
        this.queue.enqueue((Queueable)activation);
    }

    public Activation getNext() {
        return this.queue.dequeue();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean activate) {
        this.active = activate;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Activation[] getActivations() {
        return (Activation[])this.queue.toArray(new AgendaItem[this.queue.size()]);
    }

    public Activation[] getQueue() {
        return this.queue.getQueueable();
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof BinaryHeapQueueAgendaGroup)) {
            return false;
        }
        return ((BinaryHeapQueueAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        throw new UnsupportedOperationException();
    }
}

