/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.Agenda;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.ScheduledAgendaItem;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.impl.PointInTimeTrigger;

final class Scheduler {
    private Scheduler() {
    }

    public static void scheduleAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda) {
        DuractionJob job = new DuractionJob();
        DuractionJobContext ctx = new DuractionJobContext(item, agenda);
        PointInTimeTrigger trigger = new PointInTimeTrigger(item.getRule().getDuration().getDuration(item.getTuple()) + ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().getCurrentTime());
        JobHandle jobHandle = ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().scheduleJob(job, ctx, trigger);
        item.setJobHandle(jobHandle);
    }

    public static void removeAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda) {
        ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().removeJob(item.getJobHandle());
    }

    public static class DuractionJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private ScheduledAgendaItem scheduledAgendaItem;
        private Agenda agenda;

        public DuractionJobContext(ScheduledAgendaItem scheduledAgendaItem, Agenda agenda) {
            this.scheduledAgendaItem = scheduledAgendaItem;
            this.agenda = agenda;
        }

        public DuractionJobContext(ScheduledAgendaItem scheduledAgendaItem) {
            this.scheduledAgendaItem = scheduledAgendaItem;
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public ScheduledAgendaItem getScheduledAgendaItem() {
            return this.scheduledAgendaItem;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }
    }

    public static class DuractionJob
    implements Job {
        public void execute(JobContext ctx) {
            InternalAgenda agenda = (InternalAgenda)((DuractionJobContext)ctx).getAgenda();
            ScheduledAgendaItem item = ((DuractionJobContext)ctx).getScheduledAgendaItem();
            agenda.fireActivation(item);
            agenda.getScheduledActivationsLinkedList().remove(item);
            agenda.getWorkingMemory().fireAllRules();
        }
    }
}

