/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectResolver {
    private final AspectAdmin aspectAdmin;
    private final State state;
    private final ISupplementerRegistry supplementerRegistry;
    private final BundleContext weavingBundleContext;

    public AspectResolver(State state, ISupplementerRegistry supplementerRegistry, AspectAdmin aspectAdmin, BundleContext bundleContext) {
        this.state = state;
        this.supplementerRegistry = supplementerRegistry;
        this.aspectAdmin = aspectAdmin;
        this.weavingBundleContext = bundleContext;
    }

    public AspectConfiguration resolveAspectsFor(Bundle bundle, BundleDescription bundleDescription) {
        ArrayList<String> fingerprintElements = new ArrayList<String>();
        List<Definition> definitions = this.resolveAspectsForBundle(fingerprintElements, bundle, bundleDescription);
        Definition[] foundDefinitions = definitions.toArray(new Definition[definitions.size()]);
        Collections.sort(fingerprintElements);
        StringBuilder fingerprint = new StringBuilder();
        for (String element : fingerprintElements) {
            fingerprint.append(element);
            fingerprint.append(';');
        }
        return new AspectConfiguration(bundle, foundDefinitions, fingerprint.toString());
    }

    private int getApplyAspectsPolicy(ManifestElement[] headers, String manifestValue) {
        int result = 0;
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                if (headers[i].getValue().equals(manifestValue)) {
                    String directive = headers[i].getDirective("apply-aspects");
                    if ("true".equals(directive)) {
                        result = 1;
                    } else if ("false".equals(directive)) {
                        result = 2;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private String getBundleVersion(Bundle bundle) {
        return this.state.getBundle(bundle.getBundleId()).getVersion().toString();
    }

    private List<Definition> resolveAspectsForBundle(List<String> fingerprintElements, Bundle bundle, BundleDescription bundleDescription) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        if (this.weavingBundleContext != null) {
            String finishedValue;
            Definition aspects = null;
            BundleDescription[] fragments = bundleDescription.getFragments();
            int i = 0;
            while (i < fragments.length) {
                Bundle fragmentBundle = this.weavingBundleContext.getBundle(fragments[i].getBundleId());
                if (fragmentBundle != null && (aspects = this.aspectAdmin.getAspectDefinition(fragmentBundle)) != null) {
                    result.add(aspects);
                    fingerprintElements.add(String.valueOf(fragmentBundle.getSymbolicName()) + ":" + fragments[i].getVersion().toString());
                }
                ++i;
            }
            BundleDescription[] resolvedRequires = bundleDescription.getResolvedRequires();
            ManifestElement[] requireHeaders = null;
            if (resolvedRequires.length > 0) {
                try {
                    requireHeaders = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders().get("Require-Bundle")));
                }
                catch (BundleException bundleException) {}
            }
            int i2 = 0;
            while (i2 < resolvedRequires.length) {
                int applyPolicy;
                Bundle requiredBundle = this.weavingBundleContext.getBundle(resolvedRequires[i2].getBundleId());
                if (requiredBundle != null && (aspects = this.aspectAdmin.resolveRequiredBundle(requiredBundle, applyPolicy = this.getApplyAspectsPolicy(requireHeaders, requiredBundle.getSymbolicName()))) != null) {
                    result.add(aspects);
                    fingerprintElements.add(String.valueOf(requiredBundle.getSymbolicName()) + ":" + resolvedRequires[i2].getVersion().toString());
                }
                ++i2;
            }
            ExportPackageDescription[] resolvedImports = bundleDescription.getResolvedImports();
            ManifestElement[] importHeaders = null;
            if (resolvedImports.length > 0) {
                try {
                    importHeaders = ManifestElement.parseHeader((String)"Import-Package", (String)((String)bundle.getHeaders().get("Import-Package")));
                }
                catch (BundleException bundleException) {}
            }
            int i3 = 0;
            while (i3 < resolvedImports.length) {
                int applyPolicy;
                String importedPackage;
                Bundle exportingBundle = this.weavingBundleContext.getBundle(resolvedImports[i3].getExporter().getBundleId());
                if (exportingBundle != null && (aspects = this.aspectAdmin.resolveImportedPackage(exportingBundle, importedPackage = resolvedImports[i3].getName(), applyPolicy = this.getApplyAspectsPolicy(importHeaders, importedPackage))) != null) {
                    result.add(aspects);
                    fingerprintElements.add(String.valueOf(importedPackage) + ":" + resolvedImports[i3].getVersion().toString());
                }
                ++i3;
            }
            Supplementer[] supplementers = this.supplementerRegistry.getSupplementers(bundleDescription.getBundleId());
            int i4 = 0;
            while (i4 < supplementers.length) {
                aspects = this.aspectAdmin.getExportedAspectDefinitions(supplementers[i4].getSupplementerBundle());
                if (aspects != null) {
                    result.add(aspects);
                    fingerprintElements.add(String.valueOf(supplementers[i4].getSymbolicName()) + ":" + this.getBundleVersion(supplementers[i4].getSupplementerBundle()));
                }
                ++i4;
            }
            aspects = this.aspectAdmin.getAspectDefinition(bundle);
            if (!(aspects == null || (finishedValue = (String)bundle.getHeaders().get("Eclipse-AspectBundle")) != null && "finished".equals(finishedValue))) {
                result.add(aspects);
                fingerprintElements.add(String.valueOf(bundle.getSymbolicName()) + ":" + bundleDescription.getVersion().toString());
            }
        }
        return result;
    }
}

