/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.net.URL;
import java.util.List;
import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.WeavingServicePlugin;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiWeavingContext
extends DefaultWeavingContext {
    private final List<Definition> aspectDefinitions;
    private final BundleDescription bundleDescription;

    public OSGiWeavingContext(ClassLoader loader, BundleDescription bundleDescription, List<Definition> aspectDefinitions) {
        super(loader);
        this.bundleDescription = bundleDescription;
        this.aspectDefinitions = aspectDefinitions;
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("- WeavingContext.WeavingContext() locader=" + loader + ", bundle=" + bundleDescription.getSymbolicName());
        }
    }

    public String getClassLoaderName() {
        return this.bundleDescription.getSymbolicName();
    }

    public List getDefinitions(ClassLoader loader, WeavingAdaptor adaptor) {
        return this.aspectDefinitions;
    }

    public String getFile(URL url) {
        return String.valueOf(this.getBundleIdFromURL(url)) + url.getFile();
    }

    public String getId() {
        return this.bundleDescription.getSymbolicName();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.bundleDescription.getSymbolicName() + "]";
    }
}

