/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.service.weaving;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class Supplementer {
    private final ManifestElement[] supplementBundle;
    private final List<Bundle> supplementedBundles;
    private final Bundle supplementer;
    private final Bundle supplementerHost;
    private final ManifestElement[] supplementExporter;
    private final ManifestElement[] supplementImporter;

    public Supplementer(Bundle bundle, Bundle bundleHost, ManifestElement[] supplementBundle, ManifestElement[] supplementImporter, ManifestElement[] supplementExporter) {
        this.supplementer = bundle;
        this.supplementerHost = bundleHost != null ? bundleHost : bundle;
        this.supplementBundle = supplementBundle;
        this.supplementImporter = supplementImporter;
        this.supplementExporter = supplementExporter;
        this.supplementedBundles = new ArrayList<Bundle>();
    }

    public void addSupplementedBundle(Bundle supplementedBundle) {
        this.supplementedBundles.add(supplementedBundle);
    }

    public Bundle[] getSupplementedBundles() {
        return this.supplementedBundles.toArray(new Bundle[this.supplementedBundles.size()]);
    }

    public Bundle getSupplementerBundle() {
        return this.supplementer;
    }

    public Bundle getSupplementerHost() {
        return this.supplementerHost;
    }

    public String getSymbolicName() {
        return this.supplementer.getSymbolicName();
    }

    public boolean isSupplemented(Bundle bundle) {
        return this.supplementedBundles.contains(bundle);
    }

    public boolean matchesSupplementExporter(ManifestElement[] exports) {
        boolean matches = false;
        if (this.supplementExporter != null) {
            int i = 0;
            while (!matches && i < this.supplementExporter.length) {
                ManifestElement supplementExport = this.supplementExporter[i];
                int j = 0;
                while (!matches && j < exports.length) {
                    ManifestElement exportPackage = exports[j];
                    if (supplementExport.getValue().equals(exportPackage.getValue())) {
                        matches = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return matches;
    }

    public boolean matchesSupplementImporter(ManifestElement[] imports) {
        boolean matches = false;
        if (this.supplementImporter != null) {
            int i = 0;
            while (!matches && i < this.supplementImporter.length) {
                ManifestElement supplementImport = this.supplementImporter[i];
                int j = 0;
                while (!matches && j < imports.length) {
                    ManifestElement importPackage = imports[j];
                    if (supplementImport.getValue().equals(importPackage.getValue())) {
                        matches = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return matches;
    }

    public boolean matchSupplementer(String symbolicName) {
        boolean matches = false;
        if (this.supplementBundle != null) {
            int i = 0;
            while (!matches && i < this.supplementBundle.length) {
                ManifestElement bundle = this.supplementBundle[i];
                if (this.equals_wild(bundle.getValue(), symbolicName)) {
                    matches = true;
                }
                ++i;
            }
        }
        return matches;
    }

    public void removeSupplementedBundle(Bundle supplementedBundle) {
        this.supplementedBundles.remove(supplementedBundle);
    }

    private boolean equals_wild(String input, String match) {
        if (input.equals(match)) {
            return true;
        }
        if (!input.endsWith("*")) {
            return false;
        }
        String wild_in = input.substring(0, input.length() - 1);
        return match.startsWith(wild_in);
    }
}

