/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

public class NewResourceConfig
implements DOMElementVisitor {
    public static final String PARAMETER_TARGET_PROFILE = "targetProfile";
    @ConfigParam(defaultVal="##NULL")
    private String resource;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration config = new SmooksResourceConfiguration();
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
        config.setResource(this.resource);
        if (extensionContext.getDefaultSelector() != null) {
            config.setSelector(extensionContext.getDefaultSelector());
        }
        config.setSelectorNamespaceURI(extensionContext.getDefaultNamespace());
        String targetProfile = DomUtils.getAttributeValue(element, PARAMETER_TARGET_PROFILE);
        if (targetProfile == null) {
            targetProfile = extensionContext.getDefaultProfile();
        }
        config.setTargetProfile(targetProfile);
        config.setConditionEvaluator(extensionContext.getDefaultConditionEvaluator());
        extensionContext.addResource(config);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext.getExtensionContext(executionContext).getResourceStack().pop();
    }
}

