/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.DOMModel;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.DynamicSAXElementVisitorList;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomModelCreator
implements DOMVisitBefore,
SAXVisitBefore,
SAXVisitAfter,
Producer {
    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    @Config
    private SmooksResourceConfiguration config;

    public Set<String> getProducts() {
        return CollectionsUtil.toSet(this.config.getTargetElement());
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.addNodeModel(element, executionContext);
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.pushCreator(new DOMCreator(), executionContext);
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.popCreator(executionContext);
    }

    private void addNodeModel(Element element, ExecutionContext executionContext) {
        DOMModel nodeModel = DOMModel.getModel(executionContext);
        nodeModel.getModels().put(DomUtils.getName(element), element);
    }

    private void pushCreator(DOMCreator domCreator, ExecutionContext executionContext) {
        Stack<DOMCreator> domCreatorStack = (Stack<DOMCreator>)executionContext.getAttribute(DOMCreator.class);
        if (domCreatorStack == null) {
            domCreatorStack = new Stack<DOMCreator>();
            executionContext.setAttribute(DOMCreator.class, domCreatorStack);
        } else if (!domCreatorStack.isEmpty()) {
            DynamicSAXElementVisitorList.removeDynamicVisitor((SAXVisitor)domCreatorStack.peek(), executionContext);
        }
        DynamicSAXElementVisitorList.addDynamicVisitor(domCreator, executionContext);
        domCreatorStack.push(domCreator);
    }

    public Document popCreator(ExecutionContext executionContext) {
        Stack domCreatorStack = (Stack)executionContext.getAttribute(DOMCreator.class);
        if (domCreatorStack == null) {
            throw new IllegalStateException("No DOM Creator Stack available.");
        }
        try {
            if (!domCreatorStack.isEmpty()) {
                DOMCreator removedCreator = (DOMCreator)domCreatorStack.pop();
                DynamicSAXElementVisitorList.removeDynamicVisitor(removedCreator, executionContext);
                Document document = removedCreator.document;
                return document;
            }
            return null;
        }
        finally {
            if (!domCreatorStack.isEmpty()) {
                DynamicSAXElementVisitorList.addDynamicVisitor((SAXVisitor)domCreatorStack.peek(), executionContext);
            }
        }
    }

    private class DOMCreator
    implements SAXElementVisitor {
        private Document document;
        private Node currentNode;

        private DOMCreator() {
            this.document = DomModelCreator.this.documentBuilder.newDocument();
            this.currentNode = this.document;
        }

        @Override
        public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            Element domElement = element.toDOMElement(this.document);
            if (this.currentNode == this.document) {
                DomModelCreator.this.addNodeModel(domElement, executionContext);
            }
            this.currentNode.appendChild(domElement);
            this.currentNode = domElement;
        }

        @Override
        public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
            if (this.currentNode == this.document) {
                return;
            }
            if (childText.getText().trim().length() == 0) {
                return;
            }
            switch (childText.getType()) {
                case TEXT: {
                    this.currentNode.appendChild(this.document.createTextNode(childText.getText()));
                    break;
                }
                case CDATA: {
                    this.currentNode.appendChild(this.document.createCDATASection(childText.getText()));
                    break;
                }
                case COMMENT: {
                    this.currentNode.appendChild(this.document.createComment(childText.getText()));
                    break;
                }
                case ENTITY: {
                    this.currentNode.appendChild(this.document.createTextNode(childText.getText()));
                }
            }
        }

        @Override
        public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        }

        @Override
        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.currentNode = this.currentNode.getParentNode();
        }
    }
}

