/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DomUtils {
    private static Log logger = LogFactory.getLog(DomUtils.class);

    public static void copyChildNodes(Node source, Node target) {
        AssertArgument.isNotNull(source, "source");
        AssertArgument.isNotNull(target, "target");
        List nodeList = DomUtils.copyNodeList(source.getChildNodes());
        int childCount = nodeList.size();
        int i = 0;
        while (i < childCount) {
            target.appendChild((Node)nodeList.get(i));
            ++i;
        }
    }

    public static void replaceNode(Node newNode, Node oldNode) {
        AssertArgument.isNotNull(newNode, "newNode");
        AssertArgument.isNotNull(oldNode, "oldNode");
        Node parentNode = oldNode.getParentNode();
        if (parentNode == null) {
            logger.warn((Object)("Cannot replace node [" + oldNode + "] with [" + newNode + "]. [" + oldNode + "] has no parent."));
        } else {
            parentNode.replaceChild(newNode, oldNode);
        }
    }

    public static void replaceNode(NodeList newNodes, Node oldNode) {
        DomUtils.replaceNode(newNodes, oldNode, true);
    }

    public static void replaceNode(NodeList newNodes, Node oldNode, boolean clone) {
        AssertArgument.isNotNull(newNodes, "newNodes");
        AssertArgument.isNotNull(oldNode, "oldNode");
        Node parentNode = oldNode.getParentNode();
        if (parentNode == null) {
            logger.warn((Object)("Cannot replace [" + oldNode + "] with a NodeList. [" + oldNode + "] has no parent."));
            return;
        }
        int nodeCount = newNodes.getLength();
        List nodeList = DomUtils.copyNodeList(newNodes);
        if (nodeCount == 0) {
            if (!(parentNode instanceof Document)) {
                parentNode.removeChild(oldNode);
            }
            return;
        }
        if (parentNode instanceof Document) {
            List elements = DomUtils.getElements(newNodes, "*", null);
            if (!elements.isEmpty()) {
                logger.warn((Object)"Request to replace the Document root node with a 1+ in length NodeList.  Replacing root node with the first element node from the NodeList.");
                parentNode.removeChild(oldNode);
                parentNode.appendChild((Node)elements.get(0));
            } else {
                logger.warn((Object)"Cannot replace document root element with a NodeList that doesn't contain an element node.");
            }
        } else {
            int i = 0;
            while (i < nodeCount) {
                if (clone) {
                    parentNode.insertBefore(((Node)nodeList.get(i)).cloneNode(true), oldNode);
                } else {
                    parentNode.insertBefore((Node)nodeList.get(i), oldNode);
                }
                ++i;
            }
            parentNode.removeChild(oldNode);
        }
    }

    public static void insertBefore(Node newNode, Node refNode) {
        AssertArgument.isNotNull(newNode, "newNode");
        AssertArgument.isNotNull(refNode, "refNode");
        Node parentNode = refNode.getParentNode();
        if (parentNode == null) {
            logger.warn((Object)("Cannot insert [" + newNode + "] before [" + refNode + "]. [" + refNode + "] has no parent."));
            return;
        }
        if (parentNode instanceof Document && newNode.getNodeType() == 1) {
            logger.warn((Object)"Request to insert an element before the Document root node.  This is not allowed.  Replacing the Document root with the new Node.");
            parentNode.removeChild(refNode);
            parentNode.appendChild(newNode);
        } else {
            parentNode.insertBefore(newNode, refNode);
        }
    }

    public static void insertBefore(NodeList newNodes, Node refNode) {
        AssertArgument.isNotNull(newNodes, "newNodes");
        AssertArgument.isNotNull(refNode, "refNode");
        Node parentNode = refNode.getParentNode();
        if (parentNode == null) {
            logger.warn((Object)("Cannot insert a NodeList before [" + refNode + "]. [" + refNode + "] has no parent."));
            return;
        }
        int nodeCount = newNodes.getLength();
        List nodeList = DomUtils.copyNodeList(newNodes);
        if (nodeCount == 0) {
            return;
        }
        if (parentNode instanceof Document) {
            List elements = DomUtils.getElements(newNodes, "*", null);
            if (!elements.isEmpty()) {
                logger.warn((Object)"Request to insert a NodeList before the Document root node.  Will replace the root element with the 1st element node from the NodeList.");
                parentNode.removeChild(refNode);
                parentNode.appendChild((Node)elements.get(0));
            } else {
                logger.warn((Object)"Cannot insert beforen the document root element from a NodeList that doesn't contain an element node.");
            }
            int i = 0;
            while (i < nodeCount) {
                Node node = (Node)nodeList.get(i);
                if (node.getNodeType() != 1) {
                    System.out.println("****" + node);
                    parentNode.insertBefore(node, refNode);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nodeCount) {
                parentNode.insertBefore((Node)nodeList.get(i), refNode);
                ++i;
            }
        }
    }

    public static Element renameElement(Element element, String replacementElement, boolean keepChildContent, boolean keepAttributes) {
        AssertArgument.isNotNull(element, "element");
        AssertArgument.isNotNull(replacementElement, "replacementElement");
        Element replacement = element.getOwnerDocument().createElement(replacementElement);
        if (keepChildContent) {
            DomUtils.copyChildNodes(element, replacement);
        }
        if (keepAttributes) {
            NamedNodeMap attributes = element.getAttributes();
            int attributeCount = attributes.getLength();
            int i = 0;
            while (i < attributeCount) {
                Attr attribute = (Attr)attributes.item(i);
                replacement.setAttribute(attribute.getName(), attribute.getValue());
                ++i;
            }
        }
        DomUtils.replaceNode(replacement, (Node)element);
        return replacement;
    }

    public static void removeElement(Element element, boolean keepChildren) {
        AssertArgument.isNotNull(element, "element");
        Node parent = element.getParentNode();
        if (parent == null) {
            logger.warn((Object)("Cannot remove element [" + element + "]. [" + element + "] has no parent."));
            return;
        }
        NodeList children = element.getChildNodes();
        if (parent instanceof Document) {
            List childElements = null;
            if (!keepChildren) {
                logger.warn((Object)("Cannot remove document root element [" + DomUtils.getName(element) + "] without keeping child content."));
            } else {
                if (children != null && children.getLength() > 0) {
                    childElements = DomUtils.getElements(element, "*", null);
                }
                if (childElements != null && !childElements.isEmpty()) {
                    parent.removeChild(element);
                    parent.appendChild((Element)childElements.get(0));
                } else {
                    logger.warn((Object)("Cannot remove empty document root element [" + DomUtils.getName(element) + "]."));
                }
            }
        } else {
            if (keepChildren && children != null) {
                DomUtils.insertBefore(children, (Node)element);
            }
            parent.removeChild(element);
        }
    }

    public static void removeChildren(Node node) {
        AssertArgument.isNotNull(node, "node");
        NodeList children = node.getChildNodes();
        int nodeCount = children.getLength();
        int i = 0;
        while (i < nodeCount) {
            node.removeChild(children.item(0));
            ++i;
        }
    }

    public static List copyNodeList(NodeList nodeList) {
        Vector<Node> copy = new Vector<Node>();
        if (nodeList != null) {
            int nodeCount = nodeList.getLength();
            int i = 0;
            while (i < nodeCount) {
                copy.add(nodeList.item(i));
                ++i;
            }
        }
        return copy;
    }

    public static void appendList(Node node, List nodes) {
        AssertArgument.isNotNull(node, "node");
        AssertArgument.isNotNull(nodes, "nodes");
        int nodeCount = nodes.size();
        int i = 0;
        while (i < nodeCount) {
            node.appendChild((Node)nodes.get(i));
            ++i;
        }
    }

    public static boolean getBooleanAttrib(Element element, String attribName) {
        AssertArgument.isNotNull(element, "element");
        AssertArgument.isNotNullAndNotEmpty(attribName, "attribName");
        String attribVal = element.getAttribute(attribName);
        return attribVal != null ? attribVal.equalsIgnoreCase("true") : false;
    }

    public static boolean getBooleanAttrib(Element element, String attribName, String namespaceURI) {
        AssertArgument.isNotNull(element, "element");
        AssertArgument.isNotNullAndNotEmpty(attribName, "attribName");
        AssertArgument.isNotNullAndNotEmpty(namespaceURI, "namespaceURI");
        String attribVal = element.getAttributeNS(namespaceURI, attribName);
        return attribVal != null ? attribVal.equalsIgnoreCase("true") : false;
    }

    public static Element getParentElement(Element child, String parentLocalName) {
        return DomUtils.getParentElement(child, parentLocalName, null);
    }

    public static Element getParentElement(Element child, String parentLocalName, String namespaceURI) {
        AssertArgument.isNotNull(child, "child");
        AssertArgument.isNotNullAndNotEmpty(parentLocalName, "parentLocalName");
        Node parentNode = child.getParentNode();
        while (parentNode != null && parentNode.getNodeType() == 1) {
            Element parentElement = (Element)parentNode;
            if (DomUtils.getName(parentElement).equalsIgnoreCase(parentLocalName)) {
                if (namespaceURI == null) {
                    return parentElement;
                }
                if (parentElement.getNamespaceURI().equals(namespaceURI)) {
                    return parentElement;
                }
            }
            parentNode = parentNode.getParentNode();
        }
        return null;
    }

    public static String getName(Element element) {
        AssertArgument.isNotNull(element, "element");
        String name = element.getLocalName();
        if (name != null) {
            return name;
        }
        return element.getTagName();
    }

    public static String getAttributeValue(Element element, String attributeName) {
        return DomUtils.getAttributeValue(element, attributeName, null);
    }

    public static String getAttributeValue(Element element, String attributeName, String namespaceURI) {
        AssertArgument.isNotNull(element, "element");
        AssertArgument.isNotNullAndNotEmpty(attributeName, "attributeName");
        String attributeValue = namespaceURI == null ? element.getAttribute(attributeName) : element.getAttributeNS(namespaceURI, attributeName);
        if (attributeValue.length() == 0 && !element.hasAttribute(attributeName)) {
            return null;
        }
        return attributeValue;
    }

    public static Node getPreviousSibling(Node node, short nodeType) {
        Node sibling;
        AssertArgument.isNotNull(node, "node");
        Node parent = node.getParentNode();
        if (parent == null) {
            logger.warn((Object)("Cannot get node [" + node + "] previous sibling. [" + node + "] has no parent."));
            return null;
        }
        NodeList siblings = parent.getChildNodes();
        int siblingCount = siblings.getLength();
        int nodeIndex = 0;
        int i = 0;
        while (i < siblingCount) {
            sibling = siblings.item(i);
            if (sibling == node) {
                nodeIndex = i;
                break;
            }
            ++i;
        }
        if (nodeIndex == 0) {
            return null;
        }
        i = nodeIndex - 1;
        while (i >= 0) {
            sibling = siblings.item(i);
            if (sibling.getNodeType() == nodeType) {
                return sibling;
            }
            --i;
        }
        return null;
    }

    public static int countNodesBefore(Node node, short nodeType) {
        AssertArgument.isNotNull(node, "node");
        Node parent = node.getParentNode();
        if (parent == null) {
            logger.debug((Object)("Cannot count nodes before [" + node + "]. [" + node + "] has no parent."));
            return 0;
        }
        NodeList siblings = parent.getChildNodes();
        int count = 0;
        int siblingCount = siblings.getLength();
        int i = 0;
        while (i < siblingCount) {
            Node sibling = siblings.item(i);
            if (sibling == node) break;
            if (sibling.getNodeType() == nodeType) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int countNodesBetween(Node node1, Node node2, short nodeType) {
        AssertArgument.isNotNull(node1, "node1");
        AssertArgument.isNotNull(node2, "node2");
        Node parent1 = node1.getParentNode();
        if (parent1 == null) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. [" + node1 + "] has no parent."));
            return 0;
        }
        Node parent2 = node2.getParentNode();
        if (parent2 == null) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. [" + node2 + "] has no parent."));
            return 0;
        }
        if (parent1 != parent2) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. These nodes do not share the same sparent."));
            return 0;
        }
        int countBeforeNode1 = DomUtils.countNodesBefore(node1, nodeType);
        int countBeforeNode2 = DomUtils.countNodesBefore(node2, nodeType);
        int count = countBeforeNode2 - countBeforeNode1;
        if (node1.getNodeType() == nodeType) {
            --count;
        }
        return count;
    }

    public static int countNodesBefore(Node node) {
        AssertArgument.isNotNull(node, "node");
        Node parent = node.getParentNode();
        if (parent == null) {
            logger.debug((Object)("Cannot count nodes before [" + node + "]. [" + node + "] has no parent."));
            return 0;
        }
        NodeList siblings = parent.getChildNodes();
        int count = 0;
        int siblingCount = siblings.getLength();
        int i = 0;
        while (i < siblingCount) {
            Node sibling = siblings.item(i);
            if (sibling == node) break;
            ++count;
            ++i;
        }
        return count;
    }

    public static int countNodesBetween(Node node1, Node node2) {
        AssertArgument.isNotNull(node1, "node1");
        AssertArgument.isNotNull(node2, "node2");
        Node parent1 = node1.getParentNode();
        if (parent1 == null) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. [" + node1 + "] has no parent."));
            return 0;
        }
        Node parent2 = node2.getParentNode();
        if (parent2 == null) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. [" + node2 + "] has no parent."));
            return 0;
        }
        if (parent1 != parent2) {
            logger.debug((Object)("Cannot count nodes between [" + node1 + "] and [" + node2 + "]. These nodes do not share the same sparent."));
            return 0;
        }
        int countBeforeNode1 = DomUtils.countNodesBefore(node1);
        int countBeforeNode2 = DomUtils.countNodesBefore(node2);
        int count = countBeforeNode2 - countBeforeNode1 - 1;
        return count;
    }

    public static int countElementsBefore(Node node, String tagName) {
        AssertArgument.isNotNull(node, "node");
        AssertArgument.isNotNullAndNotEmpty(tagName, "tagName");
        Node parent = node.getParentNode();
        if (parent == null) {
            logger.debug((Object)("Cannot count nodes before [" + node + "]. [" + node + "] has no parent."));
            return 0;
        }
        NodeList siblings = parent.getChildNodes();
        int count = 0;
        int siblingCount = siblings.getLength();
        int i = 0;
        while (i < siblingCount) {
            Node sibling = siblings.item(i);
            if (sibling == node) break;
            if (sibling.getNodeType() == 1 && ((Element)sibling).getTagName().equals(tagName)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String getTextBefore(Node node) {
        AssertArgument.isNotNull(node, "node");
        Node parent = node.getParentNode();
        if (parent == null) {
            logger.debug((Object)("Cannot get text before node [" + node + "]. [" + node + "] has no parent."));
            return "";
        }
        NodeList siblings = parent.getChildNodes();
        StringBuffer text = new StringBuffer();
        int siblingCount = siblings.getLength();
        int i = 0;
        while (i < siblingCount) {
            Node sibling = siblings.item(i);
            if (sibling == node) break;
            if (sibling.getNodeType() == 3) {
                text.append(((Text)sibling).getData());
            }
            ++i;
        }
        return text.toString();
    }

    public static String getTextBetween(Node node1, Node node2) {
        AssertArgument.isNotNull(node1, "node1");
        AssertArgument.isNotNull(node2, "node2");
        Node parent1 = node1.getParentNode();
        if (parent1 == null) {
            logger.debug((Object)("Cannot get text between nodes [" + node1 + "] and [" + node2 + "]. [" + node1 + "] has no parent."));
            return "";
        }
        Node parent2 = node2.getParentNode();
        if (parent2 == null) {
            logger.debug((Object)("Cannot get text between nodes [" + node1 + "] and [" + node2 + "]. [" + node2 + "] has no parent."));
            return "";
        }
        if (parent1 != parent2) {
            logger.debug((Object)("Cannot get text between nodes [" + node1 + "] and [" + node2 + "]. These nodes do not share the same sparent."));
            return "";
        }
        NodeList siblings = parent1.getChildNodes();
        StringBuffer text = new StringBuffer();
        boolean append = false;
        int siblingCount = siblings.getLength();
        int i = 0;
        while (i < siblingCount) {
            Node sibling = siblings.item(i);
            if (sibling == node1) {
                append = true;
            }
            if (sibling == node2) break;
            if (append && sibling.getNodeType() == 3) {
                text.append(((Text)sibling).getData());
            }
            ++i;
        }
        return text.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String getXPath(Node node) {
        AssertArgument.isNotNull(node, "node");
        xpath = new StringBuffer();
        parent = node.getParentNode();
        switch (node.getNodeType()) {
            case 1: {
                xpath.append(DomUtils.getXPathToken((Element)node));
                ** GOTO lbl25
            }
            case 8: {
                commentNum = DomUtils.countNodesBefore(node, (short)8);
                xpath.append("/{COMMENT}[" + commentNum + 1 + "]");
                ** GOTO lbl25
            }
            case 4: {
                cdataNum = DomUtils.countNodesBefore(node, (short)4);
                xpath.append("/{CDATA}[" + cdataNum + 1 + "]");
                if (true) ** GOTO lbl25
            }
            default: {
                throw new UnsupportedOperationException("XPath generation for supplied DOM Node type not supported.  Only supports element, comment and cdata section DOM nodes.");
            }
        }
        do {
            xpath.insert(0, DomUtils.getXPathToken((Element)parent));
            parent = parent.getParentNode();
lbl25:
            // 4 sources

        } while (parent != null && parent.getNodeType() == 1);
        return xpath.toString();
    }

    private static String getXPathToken(Element element) {
        AssertArgument.isNotNull(element, "element");
        String tagName = element.getTagName();
        int count = DomUtils.countElementsBefore(element, tagName);
        String xpathToken = count > 0 ? "/" + tagName + "[" + (count + 1) + "]" : "/" + tagName;
        return xpathToken;
    }

    public static int getDepth(Element element) {
        Node parent = element.getParentNode();
        int depth = 0;
        while (parent != null && parent.getNodeType() == 1) {
            ++depth;
            parent = parent.getParentNode();
        }
        return depth;
    }

    public static String getAllText(Element parent, boolean removeEntities) {
        AssertArgument.isNotNull(parent, "parent");
        NodeList children = parent.getChildNodes();
        StringBuffer text = new StringBuffer();
        int childCount = children.getLength();
        int i = 0;
        while (i < childCount) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    String data = ((Text)child).getData();
                    if (removeEntities) {
                        text.append(XmlUtil.removeEntities(data));
                        break;
                    }
                    text.append(data);
                    break;
                }
                case 4: {
                    text.append(((Text)child).getData());
                    break;
                }
                case 8: {
                    text.append(((Comment)child).getData());
                    break;
                }
            }
            ++i;
        }
        return text.toString();
    }

    public static void addLiteral(Element element, String literalText) {
        AssertArgument.isNotNull(element, "element");
        AssertArgument.isNotNull(literalText, "literalText");
        Document document = element.getOwnerDocument();
        Text literal = document.createTextNode(literalText);
        element.appendChild(literal);
    }

    public static Element getElement(Element parent, String localname, int position) {
        return DomUtils.getElement(parent, localname, position, null);
    }

    public static Element getElement(Element parent, String localname, int position, String namespaceURI) {
        List elements = DomUtils.getElements(parent, localname, namespaceURI);
        if ((position = Math.max(position, 1)) > elements.size()) {
            return null;
        }
        return (Element)elements.get(position - 1);
    }

    public static List getElements(Element parent, String localname, String namespaceURI) {
        AssertArgument.isNotNull(parent, "parent");
        return DomUtils.getElements(parent.getChildNodes(), localname, namespaceURI);
    }

    public static List getElements(NodeList nodeList, String localname, String namespaceURI) {
        AssertArgument.isNotNull(nodeList, "nodeList");
        AssertArgument.isNotNullAndNotEmpty(localname, "localname");
        AssertArgument.isNotEmpty(namespaceURI, "namespaceURI");
        int count = nodeList.getLength();
        Vector<Element> elements = new Vector<Element>();
        int i = 0;
        while (i < count) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if ((localname.equals("*") || DomUtils.getName(element).equals(localname)) && (namespaceURI == null || namespaceURI.equals(element.getNamespaceURI()))) {
                    elements.add(element);
                }
            }
            ++i;
        }
        return elements;
    }
}

