/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.cache.FqnComparator;
import org.jboss.cache.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn<E>
implements Comparable<Fqn<?>>,
Externalizable {
    public static final String SEPARATOR = "/";
    protected List<E> elements;
    private transient int hash_code = 0;
    protected int size = 0;
    public static final Fqn ROOT = new Fqn();
    protected String stringRepresentation;

    public Fqn() {
        this.elements = Collections.emptyList();
        this.size = 0;
    }

    @Deprecated
    public Fqn(List<? extends E> names) {
        this(names, false);
    }

    @Deprecated
    public Fqn(E ... names) {
        this(Arrays.asList(names), true);
    }

    @Deprecated
    public Fqn(Fqn<? extends E> base, Fqn<? extends E> relative) {
        this(base, relative.elements);
    }

    @Deprecated
    public Fqn(Fqn<? extends E> base, E ... childNames) {
        this(base, Arrays.asList(childNames));
    }

    @Deprecated
    protected Fqn(List<? extends E> names, boolean safe) {
        if (names != null) {
            this.elements = safe ? names : Immutables.immutableListCopy(names);
            this.size = this.elements.size();
        } else {
            this.elements = Collections.emptyList();
            this.size = 0;
        }
    }

    protected Fqn(Fqn<? extends E> base, List<? extends E> relative) {
        this.elements = Immutables.immutableListMerge(base.elements, relative);
        this.size = this.elements.size();
    }

    public static <T> Fqn<T> fromList(List<? extends T> names) {
        return new Fqn<T>(names, false);
    }

    public static <T> Fqn<T> fromList(List<? extends T> names, boolean safe) {
        return new Fqn<T>(names, safe);
    }

    public static <T> Fqn<T> fromElements(T ... elements) {
        return new Fqn<T>(Arrays.asList(elements), true);
    }

    public static <T> Fqn<T> fromRelativeFqn(Fqn<? extends T> base, Fqn<? extends T> relative) {
        return new Fqn<T>(base, relative.elements);
    }

    public static <T> Fqn<T> fromRelativeList(Fqn<? extends T> base, List<? extends T> relativeElements) {
        return new Fqn<T>(base, relativeElements);
    }

    public static <T> Fqn<T> fromRelativeElements(Fqn<? extends T> base, T ... relativeElements) {
        return new Fqn<T>(base, Arrays.asList(relativeElements));
    }

    public static Fqn<String> fromString(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.equals(SEPARATOR) || stringRepresentation.equals("")) {
            return Fqn.root();
        }
        String toMatch = stringRepresentation.startsWith(SEPARATOR) ? stringRepresentation.substring(1) : stringRepresentation;
        String[] el = toMatch.split(SEPARATOR);
        return new Fqn<String>(Immutables.immutableListWrap(el), true);
    }

    public static Fqn<?> fromExternalStream(ObjectInput in) throws IOException, ClassNotFoundException {
        Fqn f = new Fqn();
        f.readExternal(in);
        return f;
    }

    public Fqn<E> getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn<E> getSubFqn(int startIndex, int endIndex) {
        List<E> el = this.elements.subList(startIndex, endIndex);
        return new Fqn<E>(el, true);
    }

    public int size() {
        return this.size;
    }

    public Object get(int n) {
        return this.elements.get(n);
    }

    public Object getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements.get(this.size - 1);
    }

    public boolean hasElement(Object element) {
        return this.elements.indexOf(element) != -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return this.size == other.size() && ((Object)this.elements).equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this.calculateHashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentation(this.elements);
        }
        return this.stringRepresentation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.size);
        for (E element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readShort();
        this.elements = new ArrayList(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.elements.add(in.readObject());
        }
    }

    public boolean isChildOf(Fqn<? super E> parentFqn) {
        return parentFqn.size() != this.size && this.isChildOrEquals(parentFqn);
    }

    public boolean isDirectChildOf(Fqn<? super E> parentFqn) {
        return this.size == parentFqn.size() + 1 && this.isChildOf(parentFqn);
    }

    public boolean isChildOrEquals(Fqn<? super E> parentFqn) {
        List<E> parentList = parentFqn.elements;
        if (parentList.size() > this.size) {
            return false;
        }
        for (int i = parentList.size() - 1; i >= 0; --i) {
            if (parentList.get(i).equals(this.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    protected int calculateHashCode() {
        int hashCode = 19;
        for (E o : this.elements) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        if (hashCode == 0) {
            hashCode = -559038737;
        }
        return hashCode;
    }

    protected String getStringRepresentation(List<E> elements) {
        StringBuilder builder = new StringBuilder();
        for (E e : elements) {
            if (SEPARATOR.equals(e) || "".equals(e)) continue;
            builder.append(SEPARATOR);
            builder.append(e);
        }
        return builder.length() == 0 ? SEPARATOR : builder.toString();
    }

    public Fqn<E> getParent() {
        switch (this.size) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return new Fqn<E>(this.elements.subList(0, this.size - 1), true);
    }

    public static final <T> Fqn<T> root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.size == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        Object last = this.getLastElement();
        if (last instanceof String) {
            return (String)last;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<E> peekElements() {
        return this.elements;
    }

    @Override
    public int compareTo(Fqn<?> fqn) {
        return FqnComparator.INSTANCE.compare(this, fqn);
    }

    public Fqn<E> replaceAncestor(Fqn<E> oldAncestor, Fqn<E> newAncestor) {
        if (!this.isChildOf(oldAncestor)) {
            throw new IllegalArgumentException("Old ancestor must be an ancestor of the current Fqn!");
        }
        Fqn<E> subFqn = this.getSubFqn(oldAncestor.size(), this.size());
        return Fqn.fromRelativeFqn(newAncestor, subFqn);
    }
}

