/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.ExpirationAlgorithm;

public class ExpirationAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = 47338798734219507L;
    public static final String EXPIRATION_KEY = "expiration";
    @Dynamic
    private String expirationKeyName = "expiration";
    @Dynamic
    private boolean warnNoExpirationKey = true;
    @Dynamic
    private long timeToLive = -1L;

    public ExpirationAlgorithmConfig() {
        this.evictionAlgorithmClassName = ExpirationAlgorithm.class.getName();
    }

    public String getExpirationKeyName() {
        return this.expirationKeyName;
    }

    public void setExpirationKeyName(String expirationKeyName) {
        this.expirationKeyName = expirationKeyName;
    }

    public boolean isWarnNoExpirationKey() {
        return this.warnNoExpirationKey;
    }

    public void setWarnNoExpirationKey(boolean warnNoExpirationKey) {
        this.warnNoExpirationKey = warnNoExpirationKey;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        this.timeToLive = timeUnit.toMillis(timeToLive);
    }

    @Deprecated
    public void setTimeToLiveSeconds(long time) {
        this.setTimeToLive(time, TimeUnit.SECONDS);
    }

    public ExpirationAlgorithmConfig clone() throws CloneNotSupportedException {
        return (ExpirationAlgorithmConfig)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpirationAlgorithmConfig that = (ExpirationAlgorithmConfig)o;
        if (this.timeToLive != that.timeToLive) {
            return false;
        }
        if (this.warnNoExpirationKey != that.warnNoExpirationKey) {
            return false;
        }
        return !(this.expirationKeyName != null ? !this.expirationKeyName.equals(that.expirationKeyName) : that.expirationKeyName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expirationKeyName != null ? this.expirationKeyName.hashCode() : 0);
        result = 31 * result + (this.warnNoExpirationKey ? 1 : 0);
        result = 31 * result + (int)(this.timeToLive ^ this.timeToLive >>> 32);
        return result;
    }

    public void reset() {
        super.reset();
        this.evictionAlgorithmClassName = ExpirationAlgorithm.class.getName();
        this.warnNoExpirationKey = true;
        this.timeToLive = -1L;
    }

    public String toString() {
        return "ExpirationAlgorithmConfig{expirationKeyName='" + this.expirationKeyName + '\'' + ", warnNoExpirationKey=" + this.warnNoExpirationKey + ", timeToLive=" + this.timeToLive + ", maxNodes=" + this.maxNodes + ", minTTL=" + this.minTimeToLive + '}';
    }
}

