/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected final Trace trace;
    protected long startTime;
    private volatile boolean cancel;
    private final String sql;

    public abstract boolean isTransactional();

    public abstract boolean isQuery();

    public abstract ObjectArray getParameters();

    public abstract boolean isReadOnly();

    public abstract LocalResult queryMeta() throws SQLException;

    public Command(Parser parser, String string) {
        this.session = parser.getSession();
        this.sql = string;
        this.trace = this.session.getDatabase().getTrace("command");
    }

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public LocalResult query(int n) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public final LocalResult getMetaDataLocal() throws SQLException {
        return this.queryMeta();
    }

    public final ResultInterface getMetaData() throws SQLException {
        return this.queryMeta();
    }

    public ResultInterface executeQuery(int n, boolean bl) throws SQLException {
        return this.executeQueryLocal(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalResult executeQueryLocal(int n) throws SQLException {
        this.startTime = System.currentTimeMillis();
        Database database = this.session.getDatabase();
        Object object = database.getMultiThreaded() ? this.session : database;
        this.session.waitIfExclusiveModeEnabled();
        Object object2 = object;
        synchronized (object2) {
            try {
                database.checkPowerOff();
                this.session.setCurrentCommand(this, this.startTime);
                LocalResult localResult = this.query(n);
                return localResult;
            }
            catch (Throwable throwable) {
                SQLException sQLException = Message.convert(throwable);
                database.exceptionThrown(sQLException, this.sql);
                throw sQLException;
            }
            finally {
                this.stop();
            }
        }
    }

    protected void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void checkCancelled() throws SQLException {
        if (this.cancel) {
            this.cancel = false;
            throw Message.getSQLException(90051);
        }
    }

    private void stop() throws SQLException {
        long l;
        Database database;
        this.session.closeTemporaryResults();
        this.session.setCurrentCommand(null, 0L);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else if (this.session.getDatabase().getMultiThreaded() && (database = this.session.getDatabase()) != null && database.getLockMode() == 3) {
            this.session.unlockReadLocks();
        }
        if (this.trace.info() && (l = System.currentTimeMillis() - this.startTime) > 100L) {
            this.trace.info("long query: " + l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        this.startTime = System.currentTimeMillis();
        Database database = this.session.getDatabase();
        Object object = database.getMultiThreaded() ? this.session : database;
        this.session.waitIfExclusiveModeEnabled();
        Object object2 = object;
        synchronized (object2) {
            int n = this.session.getLogId();
            this.session.setCurrentCommand(this, this.startTime);
            try {
                database.checkPowerOff();
                int n2 = this.update();
                return n2;
            }
            catch (SQLException sQLException) {
                database.exceptionThrown(sQLException, this.sql);
                database.checkPowerOff();
                this.session.rollbackTo(n);
                throw sQLException;
            }
            finally {
                this.stop();
            }
        }
    }

    public void close() {
    }

    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return TraceObject.toString(this.sql, this.getParameters());
    }
}

