/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.server.ftp.FtpData;
import org.h2.server.ftp.FtpEvent;
import org.h2.server.ftp.FtpEventListener;
import org.h2.server.ftp.FtpServer;
import org.h2.store.fs.FileSystem;
import org.h2.util.StringUtils;

public class FtpControl
extends Thread {
    private static final String SERVER_NAME = "Small FTP Server";
    private FtpServer server;
    private FileSystem fs;
    private Socket control;
    private FtpData data;
    private PrintWriter output;
    private String userName;
    private boolean connected;
    private boolean readonly;
    private String currentDir = "/";
    private String serverIpAddress;
    private boolean stop;
    private String renameFrom;
    private boolean replied;
    private long restart;

    public FtpControl(Socket socket, FtpServer ftpServer, boolean bl) {
        this.server = ftpServer;
        this.fs = ftpServer.getFileSystem();
        this.control = socket;
        this.stop = bl;
    }

    public void run() {
        block7: {
            try {
                this.output = new PrintWriter(new OutputStreamWriter(this.control.getOutputStream(), "UTF8"));
                if (this.stop) {
                    this.reply(421, "Too many users");
                    break block7;
                }
                this.reply(220, SERVER_NAME);
                this.serverIpAddress = this.control.getLocalAddress().getHostAddress().replace('.', ',');
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.control.getInputStream()));
                while (!this.stop) {
                    String string = null;
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (string == null) break;
                    this.process(string);
                }
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (Throwable throwable) {
                this.server.traceError(throwable);
            }
        }
        this.server.closeConnection();
    }

    private void process(String string) throws SQLException, IOException {
        int n = string.indexOf(32);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(n).trim();
            string = string.substring(0, n);
        }
        if ((string = StringUtils.toUpperEnglish(string)).length() == 0) {
            this.reply(506, "No command");
            return;
        }
        this.server.trace(">" + string);
        FtpEventListener ftpEventListener = this.server.getEventListener();
        FtpEvent ftpEvent = null;
        if (ftpEventListener != null) {
            ftpEvent = new FtpEvent(this, string, string2);
            ftpEventListener.beforeCommand(ftpEvent);
        }
        this.replied = false;
        if (this.connected) {
            this.processConnected(string, string2);
        }
        if (!this.replied) {
            if ("USER".equals(string)) {
                this.userName = string2;
                this.reply(331, "Need password");
            } else if ("QUIT".equals(string)) {
                this.reply(221, "Bye");
                this.stop = true;
            } else if ("PASS".equals(string)) {
                if (this.userName == null) {
                    this.reply(332, "Need username");
                } else if (this.server.checkUserPassword(this.userName, string2)) {
                    this.reply(230, "Ok");
                    this.readonly = false;
                    this.connected = true;
                } else if (this.server.checkUserPasswordReadOnly(this.userName, string2)) {
                    this.reply(230, "Ok, readonly");
                    this.readonly = true;
                    this.connected = true;
                } else {
                    this.reply(431, "Wrong user/password");
                }
            } else if ("REIN".equals(string)) {
                this.userName = null;
                this.connected = false;
                this.currentDir = "/";
                this.reply(200, "Ok");
            } else if ("HELP".equals(string)) {
                this.reply(214, SERVER_NAME);
            }
        }
        if (!this.replied) {
            ftpEventListener.onUnsupportedCommand(ftpEvent);
            this.reply(506, "Invalid command");
        }
        if (ftpEventListener != null) {
            ftpEventListener.afterCommand(ftpEvent);
        }
    }

    private void processConnected(String string, String string2) throws SQLException, IOException {
        switch (string.charAt(0)) {
            case 'C': {
                if ("CWD".equals(string)) {
                    String string3 = this.getPath(string2);
                    String string4 = this.getFileName(string3);
                    if (this.fs.exists(string4) && this.fs.isDirectory(string4)) {
                        if (!string3.endsWith("/")) {
                            string3 = string3 + "/";
                        }
                        this.currentDir = string3;
                        this.reply(250, "Ok");
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"CDUP".equals(string)) break;
                if (this.currentDir.length() > 1) {
                    int n = this.currentDir.lastIndexOf("/", this.currentDir.length() - 2);
                    this.currentDir = this.currentDir.substring(0, n + 1);
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'D': {
                if (!"DELE".equals(string)) break;
                String string5 = this.getFileName(string2);
                if (!this.readonly && this.fs.exists(string5) && !this.fs.isDirectory(string5) && this.fs.tryDelete(string5)) {
                    if (this.server.getAllowTask() && string5.endsWith(".task")) {
                        this.server.stopTask(string5);
                    }
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(500, "Delete failed");
                break;
            }
            case 'L': {
                if (!"LIST".equals(string)) break;
                this.processList(string2, true);
                break;
            }
            case 'M': {
                if ("MKD".equals(string)) {
                    this.processMakeDir(string2);
                    break;
                }
                if ("MODE".equals(string)) {
                    if ("S".equals(StringUtils.toUpperEnglish(string2))) {
                        this.reply(200, "Ok");
                        break;
                    }
                    this.reply(504, "Invalid");
                    break;
                }
                if (!"MDTM".equals(string)) break;
                String string6 = this.getFileName(string2);
                if (this.fs.exists(string6) && !this.fs.isDirectory(string6)) {
                    this.reply(213, this.server.formatLastModified(string6));
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'N': {
                if ("NLST".equals(string)) {
                    this.processList(string2, false);
                    break;
                }
                if (!"NOOP".equals(string)) break;
                this.reply(200, "Ok");
                break;
            }
            case 'P': {
                if ("PWD".equals(string)) {
                    this.reply(257, StringUtils.quoteIdentifier(this.currentDir) + " directory");
                    break;
                }
                if ("PASV".equals(string)) {
                    ServerSocket serverSocket = this.server.createDataSocket();
                    this.data = new FtpData(this.server, this.control.getInetAddress(), serverSocket);
                    this.data.start();
                    int n = serverSocket.getLocalPort();
                    this.reply(227, "Passive Mode (" + this.serverIpAddress + "," + (n >> 8) + "," + (n & 0xFF) + ")");
                    break;
                }
                if (!"PORT".equals(string)) break;
                String[] stringArray = StringUtils.arraySplit(string2, ',', true);
                String string7 = stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                int n = Integer.parseInt(stringArray[4]) << 8 | Integer.parseInt(stringArray[5]);
                InetAddress inetAddress = InetAddress.getByName(string7);
                if (inetAddress.equals(this.control.getInetAddress())) {
                    this.data = new FtpData(this.server, inetAddress, n);
                    this.reply(200, "Ok");
                    break;
                }
                this.server.trace("Port REJECTED:" + inetAddress + " expected:" + this.control.getInetAddress());
                this.reply(550, "Failed");
                break;
            }
            case 'R': {
                if ("RNFR".equals(string)) {
                    String string8 = this.getFileName(string2);
                    if (this.fs.exists(string8)) {
                        this.renameFrom = string8;
                        this.reply(350, "Ok");
                        break;
                    }
                    this.reply(450, "Not found");
                    break;
                }
                if ("RNTO".equals(string)) {
                    if (this.renameFrom == null) {
                        this.reply(503, "RNFR required");
                        break;
                    }
                    String string9 = this.renameFrom;
                    String string10 = this.getFileName(string2);
                    boolean bl = false;
                    if (!this.readonly) {
                        try {
                            this.fs.rename(string9, string10);
                            this.reply(250, "Ok");
                            bl = true;
                        }
                        catch (SQLException sQLException) {
                            this.server.traceError(sQLException);
                        }
                    }
                    if (bl) break;
                    this.reply(550, "Failed");
                    break;
                }
                if ("RETR".equals(string)) {
                    String string11 = this.getFileName(string2);
                    if (this.fs.exists(string11) && !this.fs.isDirectory(string11)) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.send(this.fs, string11, this.restart);
                            this.reply(226, "Ok");
                        }
                        catch (IOException iOException) {
                            this.server.traceError(iOException);
                            this.reply(426, "Failed");
                        }
                        this.restart = 0L;
                        break;
                    }
                    this.processList(string2, true);
                    break;
                }
                if ("RMD".equals(string)) {
                    this.processRemoveDir(string2);
                    break;
                }
                if (!"REST".equals(string)) break;
                try {
                    this.restart = Integer.parseInt(string2);
                    this.reply(350, "Ok");
                }
                catch (NumberFormatException numberFormatException) {
                    this.reply(500, "Invalid");
                }
                break;
            }
            case 'S': {
                if ("SYST".equals(string)) {
                    this.reply(215, "UNIX Type: L8");
                    break;
                }
                if ("SITE".equals(string)) {
                    this.reply(500, "Not understood");
                    break;
                }
                if ("SIZE".equals(string)) {
                    if (this.fs.exists(string2 = this.getFileName(string2)) && !this.fs.isDirectory(string2)) {
                        this.reply(250, String.valueOf(this.fs.length(string2)));
                        break;
                    }
                    this.reply(500, "Failed");
                    break;
                }
                if ("STOR".equals(string)) {
                    String string12 = this.getFileName(string2);
                    if (!this.readonly && !this.fs.exists(string12) || !this.fs.isDirectory(string12)) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.receive(this.fs, string12);
                            if (this.server.getAllowTask() && string2.endsWith(".task")) {
                                this.server.startTask(string12);
                            }
                            this.reply(226, "Ok");
                        }
                        catch (Exception exception) {
                            this.server.traceError(exception);
                            this.reply(426, "Failed");
                        }
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"STRU".equals(string)) break;
                if ("F".equals(StringUtils.toUpperEnglish(string2))) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(504, "Invalid");
                break;
            }
            case 'T': {
                if (!"TYPE".equals(string)) break;
                if ("A".equals(string2 = StringUtils.toUpperEnglish(string2)) || "A N".equals(string2)) {
                    this.reply(200, "Ok");
                    break;
                }
                if ("I".equals(string2) || "L 8".equals(string2)) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(500, "Invalid");
                break;
            }
            case 'X': {
                if ("XMKD".equals(string)) {
                    this.processMakeDir(string2);
                    break;
                }
                if (!"XRMD".equals(string)) break;
                this.processRemoveDir(string2);
                break;
            }
        }
    }

    void processMakeDir(String string) throws IOException {
        String string2 = this.getFileName(string);
        boolean bl = false;
        if (!this.readonly) {
            try {
                this.fs.mkdirs(string2);
                this.reply(257, StringUtils.quoteIdentifier(string) + " directory");
                bl = true;
            }
            catch (SQLException sQLException) {
                this.server.traceError(sQLException);
            }
        }
        if (!bl) {
            this.reply(500, "Failed");
        }
    }

    void processRemoveDir(String string) throws IOException {
        String string2 = this.getFileName(string);
        if (!this.readonly && this.fs.exists(string2) && this.fs.isDirectory(string2) && this.fs.tryDelete(string2)) {
            this.reply(250, "Ok");
        } else {
            this.reply(500, "Failed");
        }
    }

    private String getFileName(String string) {
        return this.server.getFileName(string.startsWith("/") ? string : this.currentDir + string);
    }

    private String getPath(String string) {
        return string.startsWith("/") ? string : this.currentDir + string;
    }

    private void processList(String string, boolean bl) throws SQLException, IOException {
        String string2 = this.getFileName(string);
        if (!this.fs.exists(string2)) {
            this.reply(450, "Directory does not exist");
            return;
        }
        if (!this.fs.isDirectory(string2)) {
            this.reply(450, "Not a directory");
            return;
        }
        String string3 = this.server.getDirectoryListing(string2, bl);
        this.reply(150, "Starting transfer");
        this.server.trace(string3);
        this.data.send(string3.getBytes());
        this.reply(226, "Done");
    }

    private void reply(int n, String string) throws IOException {
        this.server.trace(n + " " + string);
        this.output.print(n + " " + string + "\r\n");
        this.output.flush();
        this.replied = true;
    }
}

