/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

final class BoundedSize
implements Size,
Serializable {
    private final Size basis;
    private Size lowerBound;
    private Size upperBound;

    BoundedSize(Size basis, Size lowerBound, Size upperBound) {
        if (basis == null) {
            throw new NullPointerException("The basis of a bounded size must not be null.");
        }
        this.basis = basis;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    BoundedSize(Size basis) {
        this(basis, null, null);
    }

    void setLowerBound(Size lowerBound) {
        this.lowerBound = lowerBound;
    }

    void setUpperBound(Size upperBound) {
        this.upperBound = upperBound;
    }

    public int maximumSize(Container container, List components, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure) {
        int size = this.basis.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure);
        if (this.lowerBound != null) {
            size = Math.max(size, this.lowerBound.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure));
        }
        if (this.upperBound != null) {
            size = Math.min(size, this.upperBound.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure));
        }
        return size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundedSize)) {
            return false;
        }
        BoundedSize size = (BoundedSize)object;
        return this.basis.equals(size.basis) && (this.lowerBound == null && size.lowerBound == null || this.lowerBound != null && this.lowerBound.equals(size.lowerBound)) && (this.upperBound == null && size.upperBound == null || this.upperBound != null && this.upperBound.equals(size.upperBound));
    }

    public int hashCode() {
        int hashValue = this.basis.hashCode();
        if (this.lowerBound != null) {
            hashValue = hashValue * 37 + this.lowerBound.hashCode();
        }
        if (this.upperBound != null) {
            hashValue = hashValue * 37 + this.upperBound.hashCode();
        }
        return hashValue;
    }

    public String toString() {
        if (this.lowerBound != null) {
            if (this.upperBound == null) {
                return "max(" + this.basis + ';' + this.lowerBound + ')';
            }
            return "max(" + this.basis + ';' + "min(" + this.lowerBound + ';' + this.upperBound + "))";
        }
        if (this.upperBound != null) {
            return "min(" + this.basis + ';' + this.upperBound + ')';
        }
        return "bounded(" + this.basis + ')';
    }
}

