package com.redhat.installer.validator;

import java.util.Hashtable;

import javax.naming.*;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/** Verify that we can authenticate with the LDAP server. */
public class LdapValidator implements DataValidator, Validator {

    String warning;

    public static DirContext makeConnection(String dnServer, String dn, String dnPassword)  {
        /** Ldap Explanation
         * 1. Indicate you're using the LDAP service provider
         * 2. Specify where ldap is running
         * 3. Specify name of the user/program that is doing the authentication
         * 4. Specify the credentials of the user/program doing the authentication.
         *
         * Note:
         * You can specify SECURITY_AUTHENTICATION with "none" or "simple"
         * If unspecified behaviour is determined by the service provider
         */
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(Context.PROVIDER_URL, dnServer);
        env.put(Context.SECURITY_PRINCIPAL, dn);
        env.put(Context.SECURITY_CREDENTIALS, dnPassword);
        DirContext ctx = null;

        //TODO: make error messages for specific cases, since we are given good exceptions
        // upon the ctx = new InitialDirContext(env) failure.
        try { ctx = new InitialDirContext(env); }
        // incorrect dn or password
        catch (AuthenticationException e) { return ctx;}
        // incorrect URL
        catch (CommunicationException e) {return ctx;}
        // something catastrophic
        catch (NamingException e) { return ctx; }
        return ctx;
    }

    public Status validateData(AutomatedInstallData adata) {
        setWarningMessageId(adata.langpack.getString("Ldap.error"));
        String dnServer = adata.getVariable("ldap.url");
        String dn = adata.getVariable("ldap.dn");
        String dnPassword = adata.getVariable("ldap.password");
        String baseDn = adata.getVariable("ldap.basedn" );

        DirContext ctx = makeConnection(dnServer, dn, dnPassword);
        if (ctx == null) return Status.WARNING;
        return Status.OK;
    }

    //Used through test button of userInputPanel
    public boolean validate(ProcessingClient client)
    {
        Status status =  validateData(AutomatedInstallData.getInstance());
        if (status == Status.OK)
            return true;
        else
            return false;
    }
    public String getErrorMessageId() {
        return null;
    }

    public String getWarningMessageId() {
        return warning;
    }

    private void setWarningMessageId(String warning) {
      this.warning = warning;
    }

    public boolean getDefaultAnswer() {
        return false;
    }
}