package com.redhat.installer.tests.postinstall;

import com.redhat.installer.postinstall.FileDeleter;
import com.redhat.installer.tests.ProcessPanelTester;
import com.redhat.installer.tests.TestUtils;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import java.io.File;

import static junit.framework.TestCase.assertFalse;

/**
 * Created by thauser on 2/6/14.
 */
public class FileDeleterTest extends ProcessPanelTester {
    FileDeleter fd;

    @BeforeClass
    public static void specificInit() throws Exception {
        idata.langpack = TestUtils.createMockLangpack("FileDeleter.failure","FileDeleter.success");
    }

    @Before
    public void setUp() throws Exception{
        fd = new FileDeleter();
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory(TestUtils.INSTALL_PATH_FILE);
        fd = null;
    }

    @Test
    public void testSingleFileDelete() throws Exception {
        String path = "/delete-singlefiletest.file";
        TestUtils.createNewEmptyFile(path);
        fd.run(handler, new String[] {TestUtils.baseTestDir + path});
        assertFalse(new File(TestUtils.baseTestDir + path).exists());
    }

    @Test
    public void testMultiFileDelete() throws Exception {
        String [] paths = {"/delete-multi1.file", "/delete-multi2.file", "delete-multi3.file"};
        String [] fullPaths = new String[3];
        for (int i = 0; i < fullPaths.length; i++){
            fullPaths[i] = TestUtils.baseTestDir + paths[i];
        }
        for (String path : paths){
            TestUtils.createNewEmptyFile(path);
        }
        fd.run(handler, fullPaths);
        for (String path : paths){
            assertFalse(new File(TestUtils.baseTestDir + path).exists());
        }
    }


    @Override
    public void testProcessPanelInstantiation() {

    }
}
