/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceTitleButton;

public class TransitionAwareIcon
implements Icon {
    private AbstractButton button;
    private Delegate delegate;
    private Map<String, Icon> iconMap;

    public TransitionAwareIcon(AbstractButton button, Delegate delegate) {
        this.button = button;
        this.delegate = delegate;
        this.iconMap = new SoftHashMap<String, Icon>();
    }

    private Icon getIconToPaint() {
        ComponentState currState = ComponentState.getState(this.button.getModel(), this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        if (!currState.isKindActive(FadeKind.ENABLE)) {
            prevState = currState;
        }
        float cyclePos = currState.getCycleCount();
        SubstanceTheme currTheme = SubstanceCoreUtilities.getTheme((Component)this.button, currState, true, true);
        if (this.button instanceof SubstanceTitleButton && currState == ComponentState.DEFAULT) {
            currTheme = SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme();
        }
        SubstanceTheme prevTheme = currTheme;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.button, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS, FadeKind.ARM);
        if (fadeState != null) {
            prevTheme = SubstanceCoreUtilities.getTheme((Component)this.button, prevState, true, true);
            if (this.button instanceof SubstanceTitleButton && prevState == ComponentState.DEFAULT) {
                prevTheme = SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme();
            }
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
        }
        float currAlpha = currTheme.getThemeAlpha(this.button, currState);
        float prevAlpha = prevTheme.getThemeAlpha(this.button, prevState);
        String key = currTheme.getDisplayName() + ":" + prevTheme.getDisplayName() + ":" + currAlpha + ":" + prevAlpha + ":" + cyclePos;
        if (!this.iconMap.containsKey(key)) {
            Icon icon = this.delegate.getThemeIcon(currTheme);
            Icon prevIcon = this.delegate.getThemeIcon(prevTheme);
            BufferedImage temp = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D g2d = temp.createGraphics();
            if (currTheme == prevTheme) {
                g2d.setComposite(AlphaComposite.getInstance(3, currAlpha));
                icon.paintIcon(this.button, g2d, 0, 0);
            } else {
                if (cyclePos < 10.0f) {
                    g2d.setComposite(AlphaComposite.getInstance(3, prevAlpha));
                    prevIcon.paintIcon(this.button, g2d, 0, 0);
                }
                if (cyclePos > 0.0f) {
                    g2d.setComposite(AlphaComposite.getInstance(3, currAlpha * cyclePos / 10.0f));
                    icon.paintIcon(this.button, g2d, 0, 0);
                }
            }
            this.iconMap.put(key, new ImageIcon(temp));
            g2d.dispose();
        }
        return this.iconMap.get(key);
    }

    public int getIconHeight() {
        return this.getIconToPaint().getIconHeight();
    }

    public int getIconWidth() {
        return this.getIconToPaint().getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    public static interface Delegate {
        public Icon getThemeIcon(SubstanceTheme var1);
    }
}

