package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Moves a list of files into a new location
 * Default behavior moves (deletes original), copy flag does a copy.
 * <p/>
 * Created by thauser on 7/15/14.
 */
public class FileMover {

    public static final String COPY = "copy";
    public static final String MSG_ENABLED = "enable-messages";
    public static final String SOURCE = "source";
    public static final String DEST = "destination";

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);

        boolean copy = parser.hasProperty(COPY) && Boolean.parseBoolean(parser.getStringProperty(COPY));

        boolean displayMessages = parser.hasProperty(MSG_ENABLED) && Boolean.parseBoolean(parser.getStringProperty(COPY));
        parser.getListProperty(SOURCE);

        if (parser.hasProperty(SOURCE) && parser.hasProperty(DEST)) {

            //String prefix = parser.hasProperty(PREFIX) ? parser.getStringProperty(PREFIX) : "";
            List<String> sources = parser.getListProperty(SOURCE);
            File dest = new File(parser.getStringProperty(DEST));

            // if the destination isn't a directory and it already exists, we're going to mangle something
            if (!dest.isDirectory() && dest.exists()) {
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileMover.dest.exists"), true);
                return;
            }
            for (String s : sources) {
                File source = new File(s);
                String sourcePath = source.getAbsolutePath();

                // if the source doesn't exist, we're done
                if (!source.exists()) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.source.notexist"), sourcePath), false);
                    continue;
                }
                if (source.isDirectory()) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.source.isdirectory"), sourcePath), true);
                    return;
                }
                try {
                    // this call will not overwrite files. probably good, but we should catch FNFE here to give better error messages
                    if (copy) {
                        FileUtils.copyFileToDirectory(source, dest, true);
                    } else {
                        FileUtils.moveFileToDirectory(source, dest, true);
                    }
                } catch (IOException e) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.copy.failed"), sourcePath, dest.getAbsolutePath()), true);
                    continue;
                }
                if (displayMessages) {
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("FileMover.copy.success"), sourcePath, dest.getAbsolutePath()), false);
                }
            }
        } else {
            ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileMover.missing.args"), true);
            return;
        }
    }

}
