/*
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 * 
 * http://izpack.org/
 * http://izpack.codehaus.org/
 * 
 * Copyright 2005 Klaus Bartz
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.izforge.izpack.panels;

import com.izforge.izpack.gui.*;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.SummaryProcessor;

import javax.swing.*;
import java.awt.*;

/**
 * Summary panel to use before InstallPanel. This panel calls the {@link SummaryProcessor} which
 * calls all declared panels for a summary and shows the given captions and messages in a
 * <code>JEditorPane</code>.
 *
 * @author Klaus Bartz
 */
public class SummaryPanel extends IzPanel
{

    /**
     *
     */
    private static final long serialVersionUID = 3832626166401282361L;

    /**
     * The text area.
     */
    private JEditorPane textArea;
    

    /**
     * The constructor.
     *
     * @param parent The parent.
     * @param idata  The installation data.
     */
    public SummaryPanel(InstallerFrame parent, InstallData idata)
    {
        super(parent, idata, new GridBagLayout());
        addTitle();
        addInfoLabel();
        addTextArea();
    }

    private void addTitle() {
        JLabel title = LabelFactory.createTitleLabel(idata.langpack.getString("sidenav.summary"), !parent.hasBackground);
        add(title, GridBagConstraintsFactory.getTitleConstraints());
    }

    private void addTextArea() {
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.gridy = 2;
        gbc.weightx = .5;
        gbc.weighty = .5;
        gbc.fill = GridBagConstraints.BOTH;
        textArea = new JEditorPane();
        textArea.setContentType("text/html");
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setFont(FontResources.getOpenSansRegular());
        JScrollPane scroller = ScrollPaneFactory.createScroller(textArea);
        add(scroller, gbc);
    }

    private void addInfoLabel() {
        Component component = LabelFactory.create(String.format("<html>%s</html>", idata.langpack.getString("SummaryPanel.info")));
        GridBagConstraints gbc = GridBagConstraintsFactory.getBasicConstraints();
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.gridy = 1;
        add(component, gbc);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.izforge.izpack.installer.IzPanel#panelActivate()
     */
    public void panelActivate()
    {
        super.panelActivate();
        textArea.setText(SummaryProcessor.getPanelSummary(idata, true));
        textArea.setCaretPosition(0);
        setInitialFocus(getInstallerFrame().getNextButton());
    }

}
