/*
 * Copyright 2011 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.pmml.pmml_4_2;


import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;

import static org.junit.Assert.assertFalse;

public class KieBaseTest {


    @Test
    public void testKieBaseCompilation() {

        KieServices ks = KieServices.Factory.get();
        Results rs = ks.getKieClasspathContainer().verify();
        System.out.println( rs.getMessages() );
        assertFalse( rs.hasMessages( Message.Level.ERROR ) );

    }



}
