/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.common.services.project.backend.server;

import org.guvnor.common.services.project.model.Package;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class DefaultModuleResourcePathResolverTest {

    private DefaultModuleResourcePathResolver resolver;

    @Mock
    private Package pkg;

    @Mock
    private Path packageMainResourcesPath;

    @Before
    public void setUp() {
        resolver = new DefaultModuleResourcePathResolver();
        when(pkg.getPackageMainResourcesPath()).thenReturn(packageMainResourcesPath);
    }

    @Test
    public void testAcceptFile() {
        assertTrue(resolver.accept("txt"));
        assertTrue(resolver.accept("java"));
        assertTrue(resolver.accept(null));
        assertTrue(resolver.accept(""));
    }

    @Test
    public void testResolveByDefaultPath() {
        assertEquals(packageMainResourcesPath,
                     resolver.resolveDefaultPath(pkg));
        verify(pkg,
               times(1)).getPackageMainResourcesPath();
    }
}
