/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.bpmn.forms.conditions;

import java.util.Objects;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class ParseConditionResult {

    private Condition condition;

    private String error;

    public ParseConditionResult(final @MapsTo("condition") Condition condition,
                                final @MapsTo("error") String error) {
        this.condition = condition;
        this.error = error;
    }

    public ParseConditionResult(Condition condition) {
        this.condition = condition;
    }

    public ParseConditionResult(String error) {
        this.error = error;
    }

    public Condition getCondition() {
        return condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return error != null;
    }

    @Override
    public int hashCode() {
        return HashUtil.combineHashCodes(Objects.hashCode(condition),
                                         Objects.hashCode(error));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParseConditionResult) {
            ParseConditionResult other = (ParseConditionResult) o;
            return Objects.equals(condition, other.condition) &&
                    Objects.equals(error, other.error);
        }
        return false;
    }
}
