/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceTableHeaderUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceTableUI
extends BasicTableUI {
    protected Set lafWidgets;
    protected Map<TableCellId, Object> selectedIndices = new HashMap<TableCellId, Object>();
    protected Comparable<?> rolledOverId;
    protected int focusedRow = -1;
    protected int focusedColumn = -1;
    protected int rolledOverColumn = -1;
    protected Map<Class<?>, TableCellRenderer> defaultRenderers;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ListSelectionListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private Map<TableCellId, ComponentState> prevStateMap = new HashMap<TableCellId, ComponentState>();
    private Map<TableCellId, ComponentState> nextStateMap = new HashMap<TableCellId, ComponentState>();

    @Override
    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTableUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTableUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTableUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTableUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTableUI();
    }

    protected void __org__jvnet__substance__SubstanceTableUI__installDefaults() {
        Class[] defClasses;
        super.installDefaults();
        if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
            this.table.setOpaque(false);
        }
        this.defaultRenderers = new HashMap();
        for (Class clazz : defClasses = new Class[]{Object.class, Icon.class, ImageIcon.class, Number.class, Float.class, Double.class, Date.class, Boolean.class}) {
            this.defaultRenderers.put(clazz, this.table.getDefaultRenderer(clazz));
        }
        this.installRendererIfNecessary(Object.class, new SubstanceDefaultTableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new SubstanceDefaultTableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Double.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Date.class, new SubstanceDefaultTableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new SubstanceDefaultTableCellRenderer.BooleanRenderer());
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!this.table.isCellSelected(i, j)) continue;
                TableCellId cellId = new TableCellId(i, j);
                this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
                this.prevStateMap.put(cellId, ComponentState.SELECTED);
            }
        }
        boolean areAllRenderersFromSubstance = true;
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            TableCellRenderer renderer = column.getCellRenderer();
            if (renderer == null) {
                renderer = this.table.getDefaultRenderer(this.table.getColumnClass(i));
            }
            if (renderer instanceof SubstanceDefaultTableCellRenderer || renderer instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer) continue;
            areAllRenderersFromSubstance = false;
            break;
        }
        if (areAllRenderersFromSubstance) {
            Insets rendererInsets = SubstanceSizeUtils.getTableCellRendererInsets(this.table.getFont().getSize());
            JLabel dummy = new JLabel("dummy");
            dummy.setFont(this.table.getFont());
            int rowHeight = dummy.getPreferredSize().height + rendererInsets.bottom + rendererInsets.top;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    TableCellRenderer renderer = this.table.getCellRenderer(i, j);
                    rowHeight = Math.max(rowHeight, renderer.getTableCellRendererComponent((JTable)this.table, (Object)this.table.getValueAt((int)i, (int)j), (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().height);
                }
            }
            this.table.setRowHeight(rowHeight);
        }
    }

    protected void installRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isCore;
            boolean bl = isCore = currRenderer instanceof DefaultTableCellRenderer.UIResource || currRenderer.getClass().getName().startsWith("javax.swing.JTable");
            if (!isCore) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__uninstallDefaults() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isSubstanceRenderer;
            boolean bl = isSubstanceRenderer = currRenderer instanceof SubstanceDefaultTableCellRenderer || currRenderer instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
            if (!isSubstanceRenderer) {
                return;
            }
        }
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object old;
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.table.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceTableUI.this.table));
                }
                if ("columnSelectionAllowed".equals(evt.getPropertyName()) || "rowSelectionAllowed".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.syncSelection(null);
                }
                if ("model".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection(null);
                }
                if ("columnModel".equals(evt.getPropertyName())) {
                    old = (TableColumnModel)evt.getOldValue();
                    if (old != null) {
                        old.getSelectionModel().removeListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    }
                    SubstanceTableUI.this.table.getColumnModel().getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection(null);
                }
                if ("selectionModel".equals(evt.getPropertyName())) {
                    old = (ListSelectionModel)evt.getOldValue();
                    if (old != null) {
                        old.removeListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    }
                    SubstanceTableUI.this.table.getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection(null);
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTableUI.this.table.updateUI();
                        }
                    });
                }
            }
        };
        this.table.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeSelectionListener = new TableSelectionListener();
        this.table.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.table.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.addMouseListener(this.substanceFadeRolloverListener);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__uninstallListeners() {
        this.table.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.table.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        Graphics2D g2d = (Graphics2D)g.create();
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table));
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g2d.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g2d.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column <= cMax; ++column) {
                    g2d.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                    int w = cm.getColumn(column).getWidth();
                    x -= w;
                }
                g2d.drawLine(x, 0, x, tableHeight - 1);
            }
        }
        g2d.dispose();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        float endAlpha;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
        TableCellId cellId = new TableCellId(row, column);
        boolean isRollover = this.rolledOverId != null && this.rolledOverId.equals(cellId);
        ComponentState prevState = this.getPrevCellState(cellId);
        ComponentState currState = this.getCellState(cellId);
        float alphaForPrevBackground = 0.0f;
        SubstanceTheme prevTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.table, prevState, true, false);
        SubstanceTheme currTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.table, currState, true, false);
        float startAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.table, prevState, true);
        float alphaForCurrBackground = endAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.table, currState, true);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.table, cellId, FadeKind.SELECTION, FadeKind.ROLLOVER);
        if (state != null) {
            float fadeCoef = state.getFadePosition();
            float totalAlpha = 0.0f;
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
            alphaForPrevBackground = totalAlpha * fadeCoef / 10.0f;
            alphaForCurrBackground = totalAlpha * (10.0f - fadeCoef) / 10.0f;
        }
        if (!this.hasSelectionAnimations() && (prevState.isKindActive(FadeKind.SELECTION) || currState.isKindActive(FadeKind.SELECTION))) {
            alphaForPrevBackground = 0.0f;
            alphaForCurrBackground = endAlpha;
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            if (alphaForPrevBackground > 0.0f) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForPrevBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), prevTheme, 0.0f);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (alphaForCurrBackground > 0.0f) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForCurrBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), currTheme, 0.0f);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (component instanceof JComponent) {
                JComponent jRenderer;
                JComponent jComponent = jRenderer = (JComponent)component;
                synchronized (jComponent) {
                    boolean newOpaque;
                    boolean bl = newOpaque = !this.selectedIndices.containsKey(cellId) && !isRollover && state == null;
                    if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
                        newOpaque = false;
                    }
                    HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.makeNonOpaque(component, opacity);
                    }
                    component.setBounds(cellRect);
                    component.validate();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.restoreOpaque(component, opacity);
                    }
                }
            } else {
                component.setBounds(cellRect);
                component.validate();
            }
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.table);
            if (!isWatermarkBleed && component != null) {
                g2d.setColor(component.getBackground());
                g2d.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
            }
            if (alphaForPrevBackground > 0.0f && prevState != ComponentState.DEFAULT) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForPrevBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), prevTheme, 0.0f);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (alphaForCurrBackground > 0.0f && currState != ComponentState.DEFAULT) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForCurrBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), currTheme, 0.0f);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (component instanceof JComponent) {
                JComponent jRenderer;
                JComponent jComponent = jRenderer = (JComponent)component;
                synchronized (jComponent) {
                    boolean newOpaque;
                    boolean isSelected = this.hasSelectionAnimations() ? this.selectedIndices.containsKey(cellId) : this.table.isCellSelected(row, column);
                    boolean bl = newOpaque = !isSelected && !isRollover && state == null;
                    if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
                        newOpaque = false;
                    }
                    HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                    }
                    this.rendererPane.paintComponent(g2d, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                    if (!newOpaque) {
                        SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                    }
                }
            } else {
                this.rendererPane.paintComponent(g2d, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
        g2d.dispose();
    }

    private FadeTrackerCallback getCallback(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            return new RowRepaintCallback(this.table, row);
        }
        if (!hasRowSelection && hasColumnSelection) {
            return new ColumnRepaintCallback(this.table, column);
        }
        return new CellRepaintCallback(this.table, row, column);
    }

    private FadeTrackerCallback getCallback(Comparable<?> comparable) {
        if (comparable instanceof TableRowId) {
            return new RowRepaintCallback(this.table, ((TableRowId)comparable).row);
        }
        if (comparable instanceof TableColumnId) {
            return new ColumnRepaintCallback(this.table, ((TableColumnId)comparable).column);
        }
        return new CellRepaintCallback(this.table, ((TableCellId)comparable).row, ((TableCellId)comparable).column);
    }

    public Comparable<?> getId(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            return new TableRowId(row);
        }
        if (!hasRowSelection && hasColumnSelection) {
            return new TableColumnId(column);
        }
        return new TableCellId(row, column);
    }

    protected void syncSelection(ListSelectionEvent e) {
        if (this.table == null) {
            return;
        }
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        if (!this.hasSelectionAnimations()) {
            this.prevStateMap.clear();
            this.table.repaint();
            return;
        }
        int rowLeadIndex = this.table.getSelectionModel().getLeadSelectionIndex();
        int colLeadIndex = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        boolean isFocusOwner = this.table.isFocusOwner();
        HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
        boolean fadeCanceled = false;
        FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                FadeTrackerCallback callback;
                boolean cellHasFocus;
                TableCellId cellId;
                if (this.table.isCellSelected(i, j)) {
                    cellId = new TableCellId(i, j);
                    if (!this.selectedIndices.containsKey(cellId)) {
                        if (!fadeCanceled) {
                            long fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 15) {
                                SubstanceFadeUtilities.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        } else {
                            new CellRepaintCallback(this.table, i, j).fadeEnded(FadeKind.SELECTION);
                        }
                        this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
                    }
                } else {
                    cellId = new TableCellId(i, j);
                    if (this.selectedIndices.containsKey(cellId)) {
                        Object oldValue = this.selectedIndices.get(cellId);
                        Object currValue = this.table.getValueAt(i, j);
                        boolean isSame = false;
                        isSame = oldValue == null ? currValue == null : oldValue.equals(currValue);
                        if (isSame) {
                            if (!fadeCanceled) {
                                long fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                                initiatedFadeSequences.add(fadeId);
                                if (initiatedFadeSequences.size() > 15) {
                                    SubstanceFadeUtilities.cancelFades(initiatedFadeSequences);
                                    initiatedFadeSequences.clear();
                                    fadeCanceled = true;
                                }
                            } else {
                                new CellRepaintCallback(this.table, i, j).fadeEnded(FadeKind.SELECTION);
                            }
                        }
                        this.selectedIndices.remove(cellId);
                    }
                }
                boolean bl = cellHasFocus = isFocusOwner && i == rowLeadIndex && j == colLeadIndex;
                if (cellHasFocus) {
                    if (this.focusedRow == i && this.focusedColumn == j) continue;
                    if (this.focusedRow >= 0 && this.focusedColumn >= 0) {
                        TableCellId prevFocusedId = new TableCellId(this.focusedRow, this.focusedColumn);
                        prevFocusedId.setExactComparison(true);
                        callback = this.getCallback(prevFocusedId);
                        FadeTracker.getInstance().trackFadeOut(FadeKind.FOCUS, (Component)this.table, prevFocusedId, false, callback);
                    }
                    FadeTrackerCallback callback2 = this.getCallback(i, j);
                    TableCellId currId = new TableCellId(i, j);
                    currId.setExactComparison(true);
                    FadeTracker.getInstance().trackFadeIn(FadeKind.FOCUS, (Component)this.table, currId, false, callback2);
                    if (!FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.FOCUS, this.table)) continue;
                    this.focusedRow = i;
                    this.focusedColumn = j;
                    continue;
                }
                if (this.focusedRow != i || this.focusedColumn != j) continue;
                TableCellId prevFocusedId = new TableCellId(this.focusedRow, this.focusedColumn);
                prevFocusedId.setExactComparison(true);
                callback = this.getCallback(prevFocusedId);
                FadeTracker.getInstance().trackFadeOut(FadeKind.FOCUS, (Component)this.table, prevFocusedId, false, callback);
                this.focusedRow = -1;
                this.focusedColumn = -1;
            }
        }
    }

    public ComponentState getPrevCellState(TableCellId cellIndex) {
        if (this.prevStateMap.containsKey(cellIndex)) {
            return this.prevStateMap.get(cellIndex);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getCellState(TableCellId cellIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        int row = cellIndex.row;
        int column = cellIndex.column;
        synthModel.setEnabled(this.table.isEnabled());
        Comparable<?> cellId = this.getId(row, column);
        synthModel.setRollover(cellId.equals(this.rolledOverId));
        if (this.hasSelectionAnimations() && FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.SELECTION, this.table)) {
            synthModel.setSelected(this.selectedIndices.containsKey(cellId));
        } else {
            synthModel.setSelected(this.table.isCellSelected(row, column));
        }
        return ComponentState.getState(synthModel, null);
    }

    protected boolean hasAnimations2() {
        int colCount;
        int rowCount = this.table.getRowCount();
        if (rowCount * (colCount = this.table.getColumnCount()) >= 500) {
            return false;
        }
        if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
            return rowCount <= 25;
        }
        if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
            return colCount <= 25;
        }
        return true;
    }

    protected boolean hasSelectionAnimations() {
        return this.hasAnimations2() && !LafWidgetUtilities.hasNoFades(this.table, FadeKind.SELECTION);
    }

    protected boolean hasRolloverAnimations() {
        return this.hasAnimations2() && !LafWidgetUtilities.hasNoFades(this.table, FadeKind.ROLLOVER);
    }

    public int getRolloverColumnIndex() {
        return this.rolledOverColumn;
    }

    public boolean isFocusedCell(int row, int column) {
        return this.focusedRow == row && this.focusedColumn == column;
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseExited(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            JTable jTable = SubstanceTableUI.this.table;
            synchronized (jTable) {
                this.fadeOut();
                this.fadeOutTableHeader();
                SubstanceTableUI.this.rolledOverId = null;
                SubstanceTableUI.this.rolledOverColumn = -1;
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
            this.handleMoveForHeader(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
            this.handleMoveForHeader(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMove(MouseEvent e) {
            JTable jTable = SubstanceTableUI.this.table;
            synchronized (jTable) {
                int row = SubstanceTableUI.this.table.rowAtPoint(e.getPoint());
                int column = SubstanceTableUI.this.table.columnAtPoint(e.getPoint());
                if (row < 0 || row >= SubstanceTableUI.this.table.getRowCount() || column < 0 || column >= SubstanceTableUI.this.table.getColumnCount()) {
                    this.fadeOut();
                    SubstanceTableUI.this.rolledOverId = null;
                } else {
                    Comparable<?> newId = SubstanceTableUI.this.getId(row, column);
                    if (SubstanceTableUI.this.rolledOverId != null && newId.equals(SubstanceTableUI.this.rolledOverId)) {
                        return;
                    }
                    this.fadeOut();
                    FadeTrackerCallback callback = SubstanceTableUI.this.getCallback(row, column);
                    if (SubstanceTableUI.this.hasRolloverAnimations()) {
                        FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, newId, false, callback);
                    } else {
                        callback.fadeEnded(FadeKind.ROLLOVER);
                    }
                    if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, SubstanceTableUI.this.table)) {
                        SubstanceTableUI.this.rolledOverId = newId;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMoveForHeader(MouseEvent e) {
            if (!SubstanceTableUI.this.table.getColumnSelectionAllowed()) {
                return;
            }
            JTableHeader header = SubstanceTableUI.this.table.getTableHeader();
            if (header == null || !header.isVisible()) {
                return;
            }
            SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)header.getUI();
            JTable jTable = SubstanceTableUI.this.table;
            synchronized (jTable) {
                int row = SubstanceTableUI.this.table.rowAtPoint(e.getPoint());
                int column = SubstanceTableUI.this.table.columnAtPoint(e.getPoint());
                if (row < 0 || row >= SubstanceTableUI.this.table.getRowCount() || column < 0 || column >= SubstanceTableUI.this.table.getColumnCount()) {
                    this.fadeOutTableHeader();
                    SubstanceTableUI.this.rolledOverColumn = -1;
                } else {
                    if (SubstanceTableUI.this.rolledOverColumn == column) {
                        return;
                    }
                    this.fadeOutTableHeader();
                    FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)header, column, false, ui.getCallback(column));
                    if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, SubstanceTableUI.this.table)) {
                        SubstanceTableUI.this.rolledOverColumn = column;
                    }
                }
            }
        }

        private void fadeOut() {
            if (SubstanceTableUI.this.rolledOverId != null) {
                FadeTrackerCallback callback = SubstanceTableUI.this.getCallback(SubstanceTableUI.this.rolledOverId);
                if (SubstanceTableUI.this.hasRolloverAnimations()) {
                    FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, SubstanceTableUI.this.rolledOverId, false, callback);
                } else {
                    callback.fadeEnded(FadeKind.ROLLOVER);
                }
            }
        }

        private void fadeOutTableHeader() {
            if (SubstanceTableUI.this.rolledOverColumn >= 0) {
                JTableHeader header = SubstanceTableUI.this.table.getTableHeader();
                if (header == null || !header.isVisible()) {
                    return;
                }
                SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)header.getUI();
                FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)header, SubstanceTableUI.this.rolledOverColumn, false, ui.getCallback(SubstanceTableUI.this.rolledOverColumn));
            }
        }
    }

    protected class TableSelectionListener
    implements ListSelectionListener {
        protected TableSelectionListener() {
        }

        public void valueChanged(final ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceTableUI.this.syncSelection(e);
                }
            });
        }
    }

    protected static class TableRowId
    implements Comparable {
        protected int row;

        public TableRowId(int row) {
            this.row = row;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableRowId) {
                TableRowId otherId = (TableRowId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.row ^ this.row >>> 32;
        }
    }

    protected static class TableColumnId
    implements Comparable {
        protected int column;

        public TableColumnId(int column) {
            this.column = column;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableColumnId) {
                TableColumnId otherId = (TableColumnId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.column ^ this.column >>> 32;
        }
    }

    protected static class TableCellId
    implements Comparable {
        protected int row;
        protected int column;
        protected boolean isExactComparison;

        public TableCellId(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public void setExactComparison(boolean isExactComparison) {
            this.isExactComparison = isExactComparison;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row && this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (!this.isExactComparison) {
                if (o instanceof TableRowId) {
                    TableRowId otherId = (TableRowId)o;
                    if (this.row == otherId.row) {
                        return 0;
                    }
                    return 1;
                }
                if (o instanceof TableColumnId) {
                    TableColumnId otherId = (TableColumnId)o;
                    if (this.column == otherId.column) {
                        return 0;
                    }
                    return 1;
                }
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return (this.row ^ this.row >>> 32) & (this.column ^ this.column >>> 32);
        }

        public String toString() {
            return this.row + ":" + this.column;
        }
    }

    protected class ColumnRepaintCallback
    extends FadeTrackerAdapter {
        protected JTable table;
        protected int columnIndex;

        public ColumnRepaintCallback(JTable table, int columnIndex) {
            this.table = table;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                    if (currState == ComponentState.DEFAULT) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintColumn();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                    if (nextState == null) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintColumn();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
                }
            }
            this.repaintColumn();
        }

        private void repaintColumn() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int columnCount = ColumnRepaintCallback.this.table.getColumnCount();
                    if (columnCount > 0 && ColumnRepaintCallback.this.columnIndex < columnCount) {
                        Rectangle rect = ColumnRepaintCallback.this.table.getCellRect(0, ColumnRepaintCallback.this.columnIndex, true);
                        for (int i = 1; i < ColumnRepaintCallback.this.table.getRowCount(); ++i) {
                            rect = rect.union(ColumnRepaintCallback.this.table.getCellRect(i, ColumnRepaintCallback.this.columnIndex, true));
                        }
                        ColumnRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class RowRepaintCallback
    extends FadeTrackerAdapter {
        protected JTable table;
        protected int rowIndex;

        public RowRepaintCallback(JTable table, int rowIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                    if (currState == ComponentState.DEFAULT) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintRow();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
                }
            }
            this.repaintRow();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                    if (nextState == null) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintRow();
        }

        private void repaintRow() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = RowRepaintCallback.this.table.getRowCount();
                    if (rowCount > 0 && RowRepaintCallback.this.rowIndex < rowCount) {
                        Rectangle rect = RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, 0, true);
                        for (int i = 1; i < RowRepaintCallback.this.table.getColumnCount(); ++i) {
                            rect = rect.union(RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, i, true));
                        }
                        RowRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class CellRepaintCallback
    extends FadeTrackerAdapter {
        protected JTable table;
        protected int rowIndex;
        protected int columnIndex;

        public CellRepaintCallback(JTable table, int rowIndex, int columnIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                    SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                } else {
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                if (nextState == null) {
                    SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                } else {
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = CellRepaintCallback.this.table.getRowCount();
                    int colCount = CellRepaintCallback.this.table.getColumnCount();
                    if (rowCount > 0 && CellRepaintCallback.this.rowIndex < rowCount && colCount > 0 && CellRepaintCallback.this.columnIndex < colCount) {
                        Rectangle rect = CellRepaintCallback.this.table.getCellRect(CellRepaintCallback.this.rowIndex, CellRepaintCallback.this.columnIndex, true);
                        CellRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }
}

