/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.resourcefactory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiComponentResourceFactory
implements ResourceFactory {
    private String jndiName;
    private InitialContext ctx;
    private Object reference;
    private Class scannable;

    public JndiComponentResourceFactory(String jndiName, Class scannable, boolean cacheReference) {
        this.jndiName = jndiName;
        this.scannable = scannable;
        try {
            this.ctx = new InitialContext();
            if (cacheReference) {
                this.reference = this.ctx.lookup(jndiName);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registered(InjectorFactory factory) {
    }

    @Override
    public Object createResource(HttpRequest request, HttpResponse response, InjectorFactory factory) {
        if (this.reference != null) {
            return this.reference;
        }
        try {
            return this.ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unregistered() {
    }

    @Override
    public Class<?> getScannableClass() {
        return this.scannable;
    }

    @Override
    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }
}

