/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.ComponentsLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TreeStructureNode
implements Externalizable {
    private static final long serialVersionUID = -9038742487716977912L;
    private static final String NULL_ID = "";
    private List<FacetEntry> facets = null;
    private List<TreeStructureNode> children = null;
    private String type;
    private String id;

    public void apply(FacesContext context, UIComponent component, Set<String> uniqueIds) {
        this.type = component.getClass().getName();
        this.id = component.getId();
        String clientId = component.getClientId(context);
        if (!uniqueIds.add(clientId)) {
            throw new IllegalStateException("duplicate Id for a component " + clientId);
        }
        Map componentFacets = component.getFacets();
        for (Map.Entry element : componentFacets.entrySet()) {
            UIComponent f = (UIComponent)element.getValue();
            if (f.isTransient()) continue;
            TreeStructureNode facet = new TreeStructureNode();
            facet.apply(context, f, uniqueIds);
            if (null == this.facets) {
                this.facets = new ArrayList<FacetEntry>(componentFacets.size());
            }
            this.facets.add(new FacetEntry((String)element.getKey(), facet));
        }
        List componentChildren = component.getChildren();
        for (UIComponent child : componentChildren) {
            if (child.isTransient()) continue;
            TreeStructureNode t = new TreeStructureNode();
            t.apply(context, child, uniqueIds);
            if (null == this.children) {
                this.children = new ArrayList<TreeStructureNode>(componentChildren.size());
            }
            this.children.add(t);
        }
    }

    public UIComponent restore(ComponentsLoader loader) {
        UIComponent component = loader.createComponent(this.type);
        component.setId(this.id);
        if (null != this.facets) {
            for (FacetEntry element : this.facets) {
                UIComponent facet = element.getNode().restore(loader);
                component.getFacets().put(element.getName(), facet);
            }
        }
        if (null != this.children) {
            for (TreeStructureNode node : this.children) {
                UIComponent child = node.restore(loader);
                component.getChildren().add(child);
            }
        }
        return component;
    }

    public List<FacetEntry> getFacets() {
        return this.facets;
    }

    public List<TreeStructureNode> getChildren() {
        return this.children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int childrenSize;
        int facetsSize;
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (NULL_ID.equals(this.id)) {
            this.id = null;
        }
        if ((facetsSize = in.readInt()) > 0) {
            this.facets = new ArrayList<FacetEntry>(facetsSize);
            for (int i = 0; i < facetsSize; ++i) {
                String facetName = in.readUTF();
                TreeStructureNode facet = new TreeStructureNode();
                facet.readExternal(in);
                this.facets.add(new FacetEntry(facetName, facet));
            }
        }
        if ((childrenSize = in.readInt()) > 0) {
            this.children = new ArrayList<TreeStructureNode>(childrenSize);
            for (int i = 0; i < childrenSize; ++i) {
                TreeStructureNode child = new TreeStructureNode();
                child.readExternal(in);
                this.children.add(child);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.type);
        out.writeUTF(null == this.id ? NULL_ID : this.id);
        if (null != this.facets) {
            out.writeInt(this.facets.size());
            for (FacetEntry entry : this.facets) {
                out.writeUTF(entry.getName());
                TreeStructureNode node = entry.getNode();
                node.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        if (null != this.children) {
            out.writeInt(this.children.size());
            for (TreeStructureNode child : this.children) {
                child.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    static final class FacetEntry
    implements Externalizable {
        private String name;
        private TreeStructureNode node;

        public String getName() {
            return this.name;
        }

        public TreeStructureNode getNode() {
            return this.node;
        }

        public FacetEntry(String name, TreeStructureNode node) {
            this.name = name;
            this.node = node;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = in.readUTF();
            this.node = new TreeStructureNode();
            this.node.readExternal(in);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
            this.node.writeExternal(out);
        }
    }
}

