/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.hibernate.eclipse.graph.layout.DummyEdgePart;
import org.hibernate.eclipse.graph.layout.xpl.OldGraphVisitor;

public class DummyEdgeCreator
extends OldGraphVisitor {
    NodeList nodeList;
    EdgeList edgeList;
    DirectedGraph graph;
    List<Edge> edgesAdded;
    List<Node> candidateList;
    int targetNodeIndex;
    boolean cleanNextTime = false;

    public void visit(DirectedGraph g) {
        this.cleanNextTime = true;
        this.init(g);
        this.setDummyEdges();
    }

    private void init(DirectedGraph graph) {
        this.graph = graph;
        this.nodeList = graph.nodes;
        this.edgeList = graph.edges;
        this.edgesAdded = new ArrayList<Edge>();
    }

    protected void setDummyEdges() {
        Node targetNode = null;
        int nodeCount = this.nodeList.size();
        if (nodeCount > 1) {
            for (Node sourceNode : this.nodeList) {
                if (sourceNode.outgoing.size() != 0 || sourceNode.incoming.size() != 0) continue;
                targetNode = this.findTargetNode(sourceNode);
                Edge edge = this.newDummyEdge(targetNode, sourceNode);
                this.edgesAdded.add(edge);
            }
        }
    }

    private Edge newDummyEdge(Node targetNode, Node sourceNode) {
        DummyEdgePart edgePart = new DummyEdgePart();
        Edge edge = new Edge((Object)edgePart, sourceNode, targetNode);
        edge.weight = 2;
        this.edgeList.add((Object)edge);
        return edge;
    }

    private Node findTargetNode(Node cantBeThis) {
        Node toReturn;
        if (this.candidateList == null) {
            this.candidateList = new NodeList();
            boolean relationshipFound = false;
            for (Node element : this.nodeList) {
                if (element.incoming.size() + element.outgoing.size() < 1) continue;
                this.candidateList.add(element);
                relationshipFound = true;
            }
            if (!relationshipFound) {
                this.candidateList = this.nodeList;
            } else {
                Comparator<Node> comparator = new Comparator<Node>(){

                    @Override
                    public int compare(Node t1, Node t2) {
                        return t1.incoming.size() - t2.incoming.size();
                    }
                };
                try {
                    Collections.sort(this.candidateList, comparator);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((toReturn = this.getNext()) == cantBeThis) {
            toReturn = this.getNext();
        }
        return toReturn;
    }

    private Node getNext() {
        this.targetNodeIndex = this.targetNodeIndex == this.candidateList.size() - 1 ? 0 : ++this.targetNodeIndex;
        return this.candidateList.get(this.targetNodeIndex);
    }

    protected void removeDummyEdges() {
        for (Edge edge : this.edgesAdded) {
            this.edgeList.remove((Object)edge);
        }
    }
}

