/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.util.CommandContext;

public class ProjectNode
extends SubqueryAwareRelationalNode {
    private List selectSymbols;
    private Map elementMap;
    private boolean needsProject = true;
    private TupleBatch currentBatch;
    private int currentRow = 1;

    protected ProjectNode() {
    }

    public ProjectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.currentRow = 1;
    }

    public List getSelectSymbols() {
        return this.selectSymbols;
    }

    public void setSelectSymbols(List symbols) {
        this.selectSymbols = symbols;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            if (this.getChildren()[0] == null) {
                this.elementMap = new HashMap();
                return;
            }
            List childElements = this.getChildren()[0].getElements();
            this.elementMap = ProjectNode.createLookupMap(childElements);
            if (childElements.size() > 0) {
                this.needsProject = false;
                if (childElements.size() != this.getElements().size()) {
                    this.needsProject = true;
                } else {
                    for (int i = 0; i < this.selectSymbols.size(); ++i) {
                        Integer index;
                        SelectSymbol symbol = (SelectSymbol)this.selectSymbols.get(i);
                        if (symbol instanceof AliasSymbol) {
                            index = (Integer)this.elementMap.get(symbol);
                            if (index != null && index == i) continue;
                            symbol = ((AliasSymbol)symbol).getSymbol();
                        }
                        if (symbol instanceof ElementSymbol || symbol instanceof AggregateSymbol) {
                            index = (Integer)this.elementMap.get(symbol);
                            if (index != null && index == i) continue;
                            this.needsProject = true;
                            break;
                        }
                        this.needsProject = true;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.currentBatch == null) {
            if (this.getChildren()[0] == null) {
                this.currentBatch = new TupleBatch(1, new List[]{Arrays.asList(new Object[0])});
                this.currentBatch.setTerminationFlag(true);
            } else {
                this.currentBatch = this.getChildren()[0].nextBatch();
            }
            if (!this.needsProject) {
                TupleBatch result = this.currentBatch;
                this.currentBatch = null;
                return result;
            }
        }
        while (this.currentRow <= this.currentBatch.getEndRow() && !this.isBatchFull()) {
            List tuple = this.currentBatch.getTuple(this.currentRow);
            ArrayList projectedTuple = new ArrayList(this.selectSymbols.size());
            for (int i = 0; i < this.selectSymbols.size(); ++i) {
                SelectSymbol symbol = (SelectSymbol)this.selectSymbols.get(i);
                this.updateTuple(symbol, tuple, projectedTuple);
            }
            this.addBatchRow(projectedTuple);
            ++this.currentRow;
        }
        if (this.currentRow > this.currentBatch.getEndRow()) {
            if (this.currentBatch.getTerminationFlag()) {
                this.terminateBatches();
            }
            this.currentBatch = null;
        }
        return this.pullBatch();
    }

    private void updateTuple(SelectSymbol symbol, List values, List tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        Integer index;
        if (symbol instanceof AliasSymbol) {
            index = (Integer)this.elementMap.get(symbol);
            if (index != null) {
                tuple.add(values.get(index));
                return;
            }
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if ((index = (Integer)this.elementMap.get(symbol)) != null) {
            tuple.add(values.get(index));
        } else if (symbol instanceof ExpressionSymbol) {
            Expression expression = ((ExpressionSymbol)symbol).getExpression();
            tuple.add(this.getEvaluator(this.elementMap).evaluate(expression, values));
        } else {
            Assertion.failed((String)QueryPlugin.Util.getString("ERR.015.006.0034", new Object[]{symbol.getClass().getName()}));
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.selectSymbols);
    }

    @Override
    public Object clone() {
        ProjectNode clonedNode = new ProjectNode();
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(ProjectNode source, ProjectNode target) {
        super.copy(source, target);
        target.selectSymbols = this.selectSymbols;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Select Columns", this.selectSymbols);
        return props;
    }
}

