/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.GroupInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.AbstractCaseExpression;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;

public class ResolverUtil {
    private ResolverUtil() {
    }

    public static String getCommonType(String[] typeNames) {
        int i;
        if (typeNames == null || typeNames.length == 0) {
            return null;
        }
        if (typeNames.length == 1) {
            return typeNames[0];
        }
        LinkedHashSet<String> commonConversions = new LinkedHashSet<String>();
        commonConversions.add(typeNames[0]);
        commonConversions.addAll(DataTypeManager.getImplicitConversions((String)typeNames[0]));
        for (i = 1; i < typeNames.length; ++i) {
            LinkedHashSet<String> conversions = new LinkedHashSet<String>(DataTypeManager.getImplicitConversions((String)typeNames[i]));
            conversions.add(typeNames[i]);
            commonConversions.retainAll(conversions);
        }
        if (commonConversions.isEmpty()) {
            return null;
        }
        for (i = 0; i < typeNames.length; ++i) {
            if (!commonConversions.contains(typeNames[i])) continue;
            return typeNames[i];
        }
        commonConversions.remove("string");
        commonConversions.remove("object");
        if (!commonConversions.isEmpty()) {
            return (String)commonConversions.iterator().next();
        }
        return null;
    }

    public static boolean canImplicitlyConvert(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        return DataTypeManager.isImplicitConversion((String)fromType, (String)toType);
    }

    public static Expression convertExpression(Expression sourceExpression, String targetTypeName, QueryMetadataInterface metadata) throws QueryResolverException {
        return ResolverUtil.convertExpression(sourceExpression, DataTypeManager.getDataTypeName((Class)sourceExpression.getType()), targetTypeName, metadata);
    }

    public static Expression convertExpression(Expression sourceExpression, String sourceTypeName, String targetTypeName, QueryMetadataInterface metadata) throws QueryResolverException {
        if (sourceTypeName.equals(targetTypeName)) {
            return sourceExpression;
        }
        if (ResolverUtil.canImplicitlyConvert(sourceTypeName, targetTypeName) || sourceExpression instanceof Constant && ResolverUtil.convertConstant(sourceTypeName, targetTypeName, (Constant)sourceExpression) != null) {
            return ResolverUtil.getConversion(sourceExpression, sourceTypeName, targetTypeName, true, metadata.getFunctionLibrary());
        }
        throw new QueryResolverException("ERR.015.008.0041", QueryPlugin.Util.getString("ERR.015.008.0041", new Object[]{targetTypeName, sourceExpression, sourceTypeName}));
    }

    public static Constant convertConstant(String sourceTypeName, String targetTypeName, Constant constant) {
        if (!DataTypeManager.isTransformable((String)sourceTypeName, (String)targetTypeName)) {
            return null;
        }
        try {
            Constant result = ResolverUtil.getProperlyTypedConstant(constant.getValue(), DataTypeManager.getDataTypeClass((String)targetTypeName));
            if ("string".equals(sourceTypeName)) {
                String value;
                if ("char".equals(targetTypeName) && (value = (String)constant.getValue()) != null && value.length() != 1) {
                    return null;
                }
                return result;
            }
            if (!DataTypeManager.isTransformable((String)targetTypeName, (String)sourceTypeName)) {
                return null;
            }
            if (!(constant.getValue() instanceof Comparable)) {
                return null;
            }
            Constant reverse = ResolverUtil.getProperlyTypedConstant(result.getValue(), constant.getType());
            if (((Comparable)constant.getValue()).compareTo(reverse.getValue()) == 0) {
                return result;
            }
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
        return null;
    }

    public static Function getConversion(Expression sourceExpression, String sourceTypeName, String targetTypeName, boolean implicit, FunctionLibrary library) {
        Class srcType = DataTypeManager.getDataTypeClass((String)sourceTypeName);
        FunctionDescriptor fd = library.findTypedConversionFunction(srcType, DataTypeManager.getDataTypeClass((String)targetTypeName));
        Function conversion = new Function(fd.getName(), new Expression[]{sourceExpression, new Constant(targetTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)targetTypeName));
        conversion.setFunctionDescriptor(fd);
        if (implicit) {
            conversion.makeImplicit();
        }
        return conversion;
    }

    public static void setDesiredType(Expression expression, Class<?> targetType, LanguageObject surroundingExpression) throws QueryResolverException {
        Function f;
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.isPositional() && ref.getType() == null) {
                if (targetType == null) {
                    throw new QueryResolverException("ERR.015.008.0026", QueryPlugin.Util.getString("ERR.015.008.0026", new Object[]{surroundingExpression}));
                }
                ref.setType(targetType);
            }
        } else if (expression instanceof Function && (f = (Function)expression).getType() == null) {
            f.setType(targetType);
        }
    }

    public static void resolveOrderBy(OrderBy orderBy, QueryCommand command, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        int i;
        List knownElements = command.getProjectedQuery().getSelect().getProjectedSymbols();
        boolean isSimpleQuery = false;
        List<GroupSymbol> fromClauseGroups = Collections.emptyList();
        if (command instanceof Query) {
            Query query = (Query)command;
            boolean bl = isSimpleQuery = !query.getSelect().isDistinct() && !query.hasAggregates();
            if (query.getFrom() != null) {
                fromClauseGroups = query.getFrom().getGroups();
            }
        }
        String[] knownShortNames = new String[knownElements.size()];
        ArrayList<Expression> expressions = new ArrayList<Expression>(knownElements.size());
        for (i = 0; i < knownElements.size(); ++i) {
            String name;
            SingleElementSymbol knownSymbol = (SingleElementSymbol)knownElements.get(i);
            expressions.add(SymbolMap.getExpression(knownSymbol));
            if (knownSymbol instanceof ExpressionSymbol) continue;
            knownShortNames[i] = name = knownSymbol.getShortName();
        }
        for (i = 0; i < orderBy.getVariableCount(); ++i) {
            ExpressionSymbol es;
            SingleElementSymbol sortKey = orderBy.getVariable(i);
            if (sortKey instanceof ElementSymbol) {
                ElementSymbol symbol = (ElementSymbol)sortKey;
                String groupPart = metadata.getGroupName(symbol.getName());
                String symbolName = symbol.getName();
                String shortName = symbol.getShortName();
                if (groupPart == null) {
                    int position = -1;
                    Expression matchedSymbol = null;
                    for (int j = 0; j < knownShortNames.length; ++j) {
                        if (!shortName.equalsIgnoreCase(knownShortNames[j])) continue;
                        if (matchedSymbol != null) {
                            if (((Symbol)((Object)matchedSymbol)).equals(knownElements.get(j))) continue;
                            throw new QueryResolverException("ERR.015.008.0042", QueryPlugin.Util.getString("ERR.015.008.0042", new Object[]{symbolName}));
                        }
                        matchedSymbol = (SingleElementSymbol)knownElements.get(j);
                        position = j;
                    }
                    if (matchedSymbol != null) {
                        TempMetadataID tempMetadataID = new TempMetadataID(symbol.getName(), matchedSymbol.getType());
                        symbol.setMetadataID(tempMetadataID);
                        symbol.setType(matchedSymbol.getType());
                    }
                    if (position != -1) {
                        orderBy.setExpressionPosition(i, position);
                        continue;
                    }
                }
            } else if (sortKey instanceof ExpressionSymbol && (es = (ExpressionSymbol)sortKey).getExpression() instanceof Constant) {
                Constant c = (Constant)es.getExpression();
                int elementOrder = Integer.valueOf(c.getValue().toString());
                if (elementOrder > knownElements.size() || elementOrder < 1) {
                    throw new QueryResolverException(QueryPlugin.Util.getString("SQLParser.non_position_constant", new Object[]{c}));
                }
                orderBy.setExpressionPosition(i, elementOrder - 1);
                continue;
            }
            if (command instanceof SetQuery) {
                throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.setquery_order_expression", new Object[]{sortKey}));
            }
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)sortKey, false)) {
                try {
                    ResolverVisitor.resolveLanguageObject(symbol, fromClauseGroups, command.getExternalGroupContexts(), metadata);
                }
                catch (QueryResolverException e) {
                    throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", new Object[]{symbol.getName()}));
                }
            }
            ResolverVisitor.resolveLanguageObject(sortKey, metadata);
            int index = expressions.indexOf(SymbolMap.getExpression(sortKey));
            if (index == -1 && !isSimpleQuery) {
                throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.invalid_unrelated", new Object[]{sortKey}));
            }
            orderBy.setExpressionPosition(i, index);
        }
    }

    public static Expression getDefault(ElementSymbol symbol, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        Object mid = symbol.getMetadataID();
        Class type = symbol.getType();
        String name = symbol.getCanonicalName();
        Object defaultValue = metadata.getDefaultValue(mid);
        if (defaultValue == null && !metadata.elementSupports(mid, 4)) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.required_param", new Object[]{name}));
        }
        return ResolverUtil.getProperlyTypedConstant(defaultValue, type);
    }

    private static Constant getProperlyTypedConstant(Object defaultValue, Class parameterType) throws QueryResolverException {
        try {
            Object newValue = DataTypeManager.transformValue((Object)defaultValue, (Class)parameterType);
            return new Constant(newValue, parameterType);
        }
        catch (TransformationException e) {
            throw new QueryResolverException(e, QueryPlugin.Util.getString("ResolverUtil.error_converting_value_type", new Object[]{defaultValue, defaultValue.getClass(), parameterType}));
        }
    }

    public static List<ElementSymbol> resolveElementsInGroup(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return new ArrayList<ElementSymbol>(ResolverUtil.getGroupInfo(group, metadata).getSymbolList());
    }

    static GroupInfo getGroupInfo(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        String key = "groupinfo/" + group.getCanonicalName();
        GroupInfo groupInfo = (GroupInfo)metadata.getFromMetadataCache(group.getMetadataID(), key);
        if (groupInfo == null) {
            group = (GroupSymbol)group.clone();
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            LinkedHashMap<Object, ElementSymbol> symbols = new LinkedHashMap<Object, ElementSymbol>(elementIDs.size());
            boolean groupIsAliased = group.getDefinition() != null;
            for (Object elementID : elementIDs) {
                String elementName;
                String fullName = elementName = metadata.getFullName(elementID);
                if (groupIsAliased) {
                    String shortName = metadata.getShortElementName(elementName);
                    fullName = metadata.getFullElementName(group.getName(), shortName);
                }
                ElementSymbol element = new ElementSymbol(fullName);
                element.setGroupSymbol(group);
                element.setMetadataID(elementID);
                element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(element.getMetadataID())));
                symbols.put(elementID, element);
            }
            groupInfo = new GroupInfo(symbols);
            metadata.addToMetadataCache(group.getMetadataID(), key, groupInfo);
        }
        return groupInfo;
    }

    public static List getAccessPatternElementsInGroups(QueryMetadataInterface metadata, Collection groups, boolean flatten) throws TeiidComponentException, QueryMetadataException {
        ArrayList<Cloneable> accessPatterns = null;
        for (GroupSymbol group : groups) {
            Collection accessPatternIDs = metadata.getAccessPatternsInGroup(group.getMetadataID());
            if (accessPatternIDs == null || accessPatternIDs.size() <= 0) continue;
            Iterator j = accessPatternIDs.iterator();
            if (accessPatterns == null) {
                accessPatterns = new ArrayList<Cloneable>();
            }
            while (j.hasNext()) {
                List elements = metadata.getElementIDsInAccessPattern(j.next());
                GroupInfo groupInfo = ResolverUtil.getGroupInfo(group, metadata);
                ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(elements.size());
                for (Object id : elements) {
                    ElementSymbol symbol = groupInfo.getSymbol(id);
                    assert (symbol != null);
                    result.add(symbol);
                }
                if (flatten) {
                    accessPatterns.addAll(result);
                    continue;
                }
                accessPatterns.add(new AccessPattern(result));
            }
        }
        return accessPatterns;
    }

    public static void resolveLimit(Limit limit) throws QueryResolverException {
        if (limit.getOffset() != null) {
            ResolverUtil.setDesiredType(limit.getOffset(), DataTypeManager.DefaultDataClasses.INTEGER, limit);
        }
        ResolverUtil.setDesiredType(limit.getRowLimit(), DataTypeManager.DefaultDataClasses.INTEGER, limit);
    }

    public static void resolveImplicitTempGroup(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols) throws TeiidComponentException, QueryResolverException {
        if (symbol.isImplicitTempGroupSymbol()) {
            if (metadata.getMetadataStore().getTempElementElementIDs(symbol.getCanonicalName()) == null) {
                ResolverUtil.addTempGroup(metadata, symbol, symbols, true);
            }
            ResolverUtil.resolveGroup(symbol, metadata);
        }
    }

    public static TempMetadataID addTempGroup(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols, boolean tempTable) throws QueryResolverException {
        HashSet<String> names = new HashSet<String>();
        for (SingleElementSymbol ses : symbols) {
            if (names.add(ses.getShortCanonicalName())) continue;
            throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.duplicateName", new Object[]{symbol, ses.getShortName()}));
        }
        if (tempTable) {
            ResolverUtil.resolveNullLiterals(symbols);
        }
        TempMetadataStore store = metadata.getMetadataStore();
        return store.addTempGroup(symbol.getName(), symbols, !tempTable, tempTable);
    }

    public static TempMetadataID addTempTable(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols) throws QueryResolverException {
        return ResolverUtil.addTempGroup(metadata, symbol, symbols, true);
    }

    public static void resolveNullLiterals(List symbols) {
        for (int i = 0; i < symbols.size(); ++i) {
            ElementSymbol elementSymbol;
            Class elementType;
            SingleElementSymbol symbol;
            SelectSymbol selectSymbol = (SelectSymbol)symbols.get(i);
            if (!(selectSymbol instanceof SingleElementSymbol) || !DataTypeManager.DefaultDataClasses.NULL.equals((symbol = (SingleElementSymbol)selectSymbol).getType()) && symbol.getType() != null) continue;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            Class replacement = DataTypeManager.DefaultDataClasses.STRING;
            if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                Expression expr = exprSymbol.getExpression();
                if (expr instanceof Constant) {
                    exprSymbol.setExpression(new Constant(null, replacement));
                    continue;
                }
                if (expr instanceof AbstractCaseExpression) {
                    ((AbstractCaseExpression)expr).setType(replacement);
                    continue;
                }
                if (expr instanceof ScalarSubquery) {
                    ((ScalarSubquery)expr).setType(replacement);
                    continue;
                }
                try {
                    ResolverUtil.setDesiredType(expr, replacement, symbol);
                }
                catch (QueryResolverException e) {}
                continue;
            }
            if (!(symbol instanceof ElementSymbol) || (elementType = (elementSymbol = (ElementSymbol)symbol).getType()) == null || !elementType.equals(DataTypeManager.DefaultDataClasses.NULL)) continue;
            elementSymbol.setType(replacement);
        }
    }

    public static List<GroupSymbol> findMatchingGroups(String groupContext, Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        if (groups == null) {
            return null;
        }
        LinkedList<GroupSymbol> matchedGroups = new LinkedList<GroupSymbol>();
        if (groupContext == null) {
            matchedGroups.addAll(groups);
        } else {
            for (GroupSymbol group : groups) {
                String actualVdbName;
                String fullName;
                if (!(ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = group.getCanonicalName()) ? groupContext.length() == fullName.length() : !(group.getMetadataID() instanceof TempMetadataID) && (actualVdbName = metadata.getVirtualDatabaseName()) != null && ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = actualVdbName.toUpperCase() + "." + fullName) && groupContext.length() == fullName.length())) continue;
                return matchedGroups;
            }
        }
        return matchedGroups;
    }

    private static boolean nameMatchesGroup(String groupContext, String fullName) {
        int matchIndex;
        return fullName.endsWith(groupContext) && ((matchIndex = fullName.length() - groupContext.length()) == 0 || fullName.charAt(matchIndex - 1) == '.');
    }

    private static boolean nameMatchesGroup(String groupContext, LinkedList<GroupSymbol> matchedGroups, GroupSymbol group, String fullName) {
        if (ResolverUtil.nameMatchesGroup(groupContext, fullName)) {
            matchedGroups.add(group);
            return true;
        }
        return false;
    }

    static Expression resolveSubqueryPredicateCriteria(Expression expression, SubqueryContainer crit, QueryMetadataInterface metadata) throws QueryResolverException {
        Class exprType = expression.getType();
        if (exprType == null) {
            throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", new Object[]{expression}));
        }
        String exprTypeName = DataTypeManager.getDataTypeName((Class)exprType);
        List<SingleElementSymbol> projectedSymbols = crit.getCommand().getProjectedSymbols();
        if (projectedSymbols.size() != 1) {
            throw new QueryResolverException("ERR.015.008.0032", QueryPlugin.Util.getString("ERR.015.008.0032", new Object[]{crit.getCommand()}));
        }
        Class subqueryType = ((Expression)projectedSymbols.iterator().next()).getType();
        String subqueryTypeName = DataTypeManager.getDataTypeName((Class)subqueryType);
        Expression result = null;
        try {
            result = ResolverUtil.convertExpression(expression, exprTypeName, subqueryTypeName, metadata);
        }
        catch (QueryResolverException qre) {
            throw new QueryResolverException((Throwable)((Object)qre), "ERR.015.008.0033", QueryPlugin.Util.getString("ERR.015.008.0033", new Object[]{crit}));
        }
        return result;
    }

    public static ResolvedLookup resolveLookup(Function lookup, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        Expression[] args = lookup.getArgs();
        ResolvedLookup result = new ResolvedLookup();
        if (!(args[0] instanceof Constant && args[1] instanceof Constant && args[2] instanceof Constant)) {
            throw new QueryResolverException("ERR.015.008.0063", QueryPlugin.Util.getString("ERR.015.008.0063"));
        }
        GroupSymbol groupSym = new GroupSymbol((String)((Constant)args[0]).getValue());
        try {
            groupSym.setMetadataID(metadata.getGroupID((String)((Constant)args[0]).getValue()));
            if (groupSym.getMetadataID() instanceof TempMetadataID) {
                throw new QueryResolverException("ERR.015.008.0065", QueryPlugin.Util.getString("ERR.015.008.0065", new Object[]{((Constant)args[0]).getValue()}));
            }
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", new Object[]{((Constant)args[0]).getValue()}));
        }
        result.setGroup(groupSym);
        List<GroupSymbol> groups = Arrays.asList(groupSym);
        String returnElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[1]).getValue();
        ElementSymbol returnElement = new ElementSymbol(returnElementName);
        try {
            ResolverVisitor.resolveLanguageObject(returnElement, groups, metadata);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", new Object[]{returnElementName}));
        }
        result.setReturnElement(returnElement);
        String keyElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[2]).getValue();
        ElementSymbol keyElement = new ElementSymbol(keyElementName);
        try {
            ResolverVisitor.resolveLanguageObject(keyElement, groups, metadata);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", new Object[]{keyElementName}));
        }
        result.setKeyElement(keyElement);
        args[3] = ResolverUtil.convertExpression(args[3], DataTypeManager.getDataTypeName((Class)keyElement.getType()), metadata);
        return result;
    }

    private static QueryResolverException handleUnresolvedGroup(GroupSymbol symbol, String description) {
        UnresolvedSymbolDescription usd = new UnresolvedSymbolDescription(symbol.toString(), description);
        QueryResolverException e = new QueryResolverException(usd.getDescription() + ": " + usd.getSymbol());
        e.setUnresolvedSymbols(Arrays.asList(usd));
        return e;
    }

    public static void resolveGroup(GroupSymbol symbol, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        String vdbName;
        Object groupID;
        String definition;
        String name;
        String potentialID;
        block27: {
            String[] parts;
            if (symbol.getMetadataID() != null) {
                return;
            }
            potentialID = symbol.getNonCorrelationName();
            name = symbol.getName();
            definition = symbol.getDefinition();
            groupID = null;
            try {
                groupID = metadata.getGroupID(potentialID);
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
            vdbName = null;
            if (groupID == null && (parts = potentialID.split("\\.", 2)).length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
                try {
                    groupID = metadata.getGroupID(parts[1]);
                }
                catch (QueryMetadataException e) {
                    // empty catch block
                }
                if (groupID != null) {
                    potentialID = parts[1];
                    vdbName = parts[0];
                }
            }
            if (groupID == null) {
                Collection groupNames = null;
                try {
                    groupNames = metadata.getGroupsForPartialName(potentialID);
                }
                catch (QueryMetadataException e) {
                    // empty catch block
                }
                if (groupNames != null) {
                    int matches = groupNames.size();
                    if (matches == 1) {
                        potentialID = (String)groupNames.iterator().next();
                        try {
                            groupID = metadata.getGroupID(potentialID);
                            if (symbol.getDefinition() != null) {
                                symbol.setDefinition(potentialID);
                                break block27;
                            }
                            symbol.setName(potentialID);
                        }
                        catch (QueryMetadataException e) {}
                    } else if (matches > 1) {
                        throw ResolverUtil.handleUnresolvedGroup(symbol, QueryPlugin.Util.getString("ERR.015.008.0055"));
                    }
                }
            }
        }
        if (groupID == null || metadata.isProcedure(groupID)) {
            try {
                StoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(potentialID);
                symbol.setProcedure(true);
                groupID = storedProcedureInfo.getProcedureID();
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
        }
        if (groupID == null) {
            throw ResolverUtil.handleUnresolvedGroup(symbol, QueryPlugin.Util.getString("ERR.015.008.0056"));
        }
        symbol.setMetadataID(groupID);
        if (vdbName != null) {
            if (symbol.getDefinition() == null) {
                symbol.setName(potentialID);
            } else {
                symbol.setDefinition(potentialID);
            }
        }
        try {
            if (!symbol.isProcedure()) {
                symbol.setIsTempTable(metadata.isTemporaryTable(groupID));
            }
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        symbol.setOutputDefinition(definition);
        symbol.setOutputName(name);
    }

    public static class ResolvedLookup {
        private GroupSymbol group;
        private ElementSymbol keyElement;
        private ElementSymbol returnElement;

        void setGroup(GroupSymbol group) {
            this.group = group;
        }

        public GroupSymbol getGroup() {
            return this.group;
        }

        void setKeyElement(ElementSymbol keyElement) {
            this.keyElement = keyElement;
        }

        public ElementSymbol getKeyElement() {
            return this.keyElement;
        }

        void setReturnElement(ElementSymbol returnElement) {
            this.returnElement = returnElement;
        }

        public ElementSymbol getReturnElement() {
            return this.returnElement;
        }
    }
}

