/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Collection;
import java.util.Iterator;
import org.teiid.query.QueryPlugin;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.validator.ValidatorFailure;

public class ValidatorReport
extends ActivityReport {
    public static final String VALIDATOR_REPORT = "Validator Report";

    public ValidatorReport() {
        super(VALIDATOR_REPORT);
    }

    public void collectInvalidObjects(Collection invalidObjects) {
        for (ValidatorFailure failure : this.getItemsByType("ValidatorFailure")) {
            if (failure.getInvalidObjectCount() <= 0) continue;
            invalidObjects.addAll(failure.getInvalidObjects());
        }
    }

    public String getFailureMessage() {
        Collection failures = this.getItemsByType("ValidatorFailure");
        if (failures.size() == 0) {
            return QueryPlugin.Util.getString("ERR.015.012.0064");
        }
        if (failures.size() == 1) {
            return failures.iterator().next().toString();
        }
        StringBuffer err = new StringBuffer();
        err.append(QueryPlugin.Util.getString("ERR.015.012.0063"));
        Iterator iter = failures.iterator();
        ValidatorFailure failure = (ValidatorFailure)iter.next();
        err.append(failure);
        while (iter.hasNext()) {
            failure = (ValidatorFailure)iter.next();
            err.append(", ");
            err.append(failure);
        }
        return err.toString();
    }

    @Override
    public String toString() {
        return this.getFailureMessage();
    }
}

