/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueComparators;

@NotThreadSafe
class GraphMerger {
    private static final PropertyMerger SKIP_MERGER = new SkipMerger();
    private static final PropertyMerger UNION_MERGER = new UnionPropertyMerger();
    private static final PropertyMerger DEFAULT_MERGER = new DefaultPropertyMerger();
    private static final Map<Name, PropertyMerger> MERGERS;
    private final Graph initialContent;

    protected GraphMerger(Graph initialContent) {
        CheckArg.isNotNull((Object)initialContent, (String)"initialContent");
        this.initialContent = initialContent;
    }

    protected void merge(Graph actualGraph, Graph.Batch batch) {
        CheckArg.isNotNull((Object)actualGraph, (String)"actualGraph");
        Subgraph subgraph = this.initialContent.getSubgraphOfDepth(Integer.MAX_VALUE).at("/");
        SubgraphNode desiredNode = subgraph.getRoot();
        boolean checkProperties = true;
        if (desiredNode.getLocation().getPath().isRoot()) {
            checkProperties = false;
        }
        Path path = desiredNode.getLocation().getPath();
        Node actualNode = actualGraph.getNodeAt(path);
        this.matchNode(batch, actualGraph, actualNode, desiredNode, checkProperties, true);
    }

    protected void createSubgraph(Graph.Batch batch, SubgraphNode initialNode, Path pathOfInitialNode) {
        batch.create(pathOfInitialNode).and(initialNode.getProperties()).ifAbsent().and();
        for (Location childLocation : initialNode.getChildren()) {
            Path path = childLocation.getPath();
            SubgraphNode initialChild = initialNode.getNode(path.getLastSegment());
            this.createSubgraph(batch, initialChild, path);
        }
    }

    protected void matchProperties(Graph.Batch batch, Node actualNode, Node desiredNode) {
        Location actualLocation = actualNode.getLocation();
        assert (actualLocation != null);
        Collection<Property> desiredProperties = desiredNode.getProperties();
        if (desiredProperties.isEmpty()) {
            return;
        }
        for (Property desiredProperty : desiredProperties) {
            Name propertyName = desiredProperty.getName();
            Property actual = actualNode.getProperty(propertyName);
            if (actual == null) {
                batch.set(desiredProperty).on(actualLocation);
                continue;
            }
            PropertyMerger merger = MERGERS.get(propertyName);
            if (merger == null) {
                merger = DEFAULT_MERGER;
            }
            merger.mergeProperty(batch, actualLocation.getPath(), actual, desiredProperty);
        }
    }

    protected void matchNode(Graph.Batch batch, Graph actualContent, Node actualNode, SubgraphNode desiredNode, boolean matchProperties, boolean matchChildren) {
        Location actualLocation = actualNode.getLocation();
        if (actualLocation == null) {
            Path path = desiredNode.getLocation().getPath();
            this.createSubgraph(batch, desiredNode, path);
            batch.create(path).and(desiredNode.getProperties()).ifAbsent().and();
        } else {
            if (matchProperties) {
                this.matchProperties(batch, actualNode, desiredNode);
            }
            if (matchChildren) {
                this.matchChildren(batch, actualContent, actualNode, desiredNode);
            }
        }
    }

    protected void matchChildren(Graph.Batch batch, Graph actualGraph, Node actualNode, SubgraphNode desiredNode) {
        for (Location childLocation : desiredNode.getChildren()) {
            Path path = childLocation.getPath();
            SubgraphNode desiredChild = desiredNode.getNode(path.getLastSegment());
            try {
                Node actualChild = actualGraph.getNodeAt(childLocation);
                this.matchNode(batch, actualGraph, actualChild, desiredChild, true, true);
            }
            catch (PathNotFoundException e) {
                this.createSubgraph(batch, desiredChild, path);
            }
        }
    }

    static {
        HashMap<Name, PropertyMerger> mergers = new HashMap<Name, PropertyMerger>();
        mergers.put(JcrLexicon.NAME, SKIP_MERGER);
        mergers.put(JcrLexicon.UUID, SKIP_MERGER);
        mergers.put(ModeShapeLexicon.UUID, SKIP_MERGER);
        mergers.put(JcrLexicon.MIXIN_TYPES, UNION_MERGER);
        MERGERS = Collections.unmodifiableMap(mergers);
    }

    protected static class DefaultPropertyMerger
    implements PropertyMerger {
        protected DefaultPropertyMerger() {
        }

        public void mergeProperty(Graph.Batch batch, Path path, Property actual, Property desired) {
            Iterator<?> actualValues = actual.getValues();
            Iterator<?> desiredValues = desired.getValues();
            boolean performSet = false;
            while (actualValues.hasNext() && desiredValues.hasNext()) {
                Object desiredValue;
                Object actualValue = actualValues.next();
                if (ValueComparators.OBJECT_COMPARATOR.compare(actualValue, desiredValue = desiredValues.next()) == 0) continue;
                performSet = true;
                break;
            }
            if (!performSet && (actualValues.hasNext() || desiredValues.hasNext())) {
                performSet = true;
            }
            if (performSet) {
                batch.set(desired).on(path);
            }
        }
    }

    protected static class UnionPropertyMerger
    implements PropertyMerger {
        protected UnionPropertyMerger() {
        }

        public void mergeProperty(Graph.Batch batch, Path path, Property actual, Property desired) {
            if (desired.size() == 0) {
                return;
            }
            HashSet unionedValues = new HashSet();
            Iterator<?> actualValues = actual.getValues();
            while (actualValues.hasNext()) {
                Object value = actualValues.next();
                if (value == null) continue;
                unionedValues.add(value);
            }
            int actualSize = unionedValues.size();
            Iterator<?> desiredValues = desired.getValues();
            while (desiredValues.hasNext()) {
                Object value = desiredValues.next();
                if (value == null) continue;
                unionedValues.add(value);
            }
            if (actualSize == unionedValues.size()) {
                return;
            }
            ((Graph.BatchConjunction)((Graph.SetValuesTo)batch.set(actual.getName()).on(path)).to(unionedValues)).and();
        }
    }

    protected static class SkipMerger
    implements PropertyMerger {
        protected SkipMerger() {
        }

        public void mergeProperty(Graph.Batch batch, Path path, Property actual, Property desired) {
        }
    }

    protected static interface PropertyMerger {
        public void mergeProperty(Graph.Batch var1, Path var2, Property var3, Property var4);
    }
}

