/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SetCriteria
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand left;
    private final Collection<? extends StaticOperand> setOperands;

    public SetCriteria(DynamicOperand left, Collection<? extends StaticOperand> setOperands) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull(setOperands, (String)"setOperands");
        CheckArg.isNotEmpty(setOperands, (String)"setOperands");
        this.left = left;
        this.setOperands = setOperands;
    }

    public SetCriteria(DynamicOperand left, StaticOperand ... setOperands) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)setOperands, (String)"setOperands");
        CheckArg.isNotEmpty((Object[])setOperands, (String)"setOperands");
        this.left = left;
        this.setOperands = Collections.unmodifiableList(Arrays.asList(setOperands));
    }

    public final DynamicOperand leftOperand() {
        return this.left;
    }

    public final Collection<? extends StaticOperand> rightOperands() {
        return this.setOperands;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.left.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetCriteria) {
            SetCriteria that = (SetCriteria)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return ((Object)this.setOperands).equals(that.setOperands);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

