/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.AnyElementObjectImpl;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class AddAttributeToAnyElementSupport
extends SpecialWizardSupport {
    static String ATTRIBUTES = "attributes";
    Set<String> attributes = new HashSet<String>();
    boolean edit = false;
    String initialName = null;
    String initialValue = null;
    protected DefaultWizardDataValidator validator = new Validator();

    public boolean isEnabled(XModelObject object) {
        return object != null && object.isObjectEditable();
    }

    public void reset() {
        this.attributes.clear();
        String[][] as = this.getAttributes();
        int i = 0;
        while (i < as.length) {
            this.attributes.add(as[i][0]);
            ++i;
        }
        this.edit = "true".equals(this.action.getProperty("edit"));
        this.initialName = this.getProperties().getProperty("name");
        this.initialValue = null;
        if (this.initialName != null) {
            this.setAttributeValue(0, "name", this.initialName);
            i = 0;
            while (i < as.length) {
                if (this.initialName.equals(as[i][0])) {
                    this.initialValue = as[i][1];
                }
                ++i;
            }
            if (this.initialValue != null) {
                this.setAttributeValue(0, "value", this.initialValue);
            }
        }
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.finish();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    protected void finish() throws XModelException {
        Properties p = this.extractStepData(0);
        String name = p.getProperty("name");
        String value = p.getProperty("value");
        String as = "";
        if (!this.edit) {
            as = this.getTarget().getAttributeValue(ATTRIBUTES);
            if (as.length() > 0) {
                as = String.valueOf(as) + AnyElementObjectImpl.SEPARATOR;
            }
            as = String.valueOf(as) + name + "=" + value;
        } else {
            String[][] attrs = this.getAttributes();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < attrs.length) {
                if (sb.length() > 0) {
                    sb.append(AnyElementObjectImpl.SEPARATOR);
                }
                sb.append(attrs[i][0]).append('=');
                if (attrs[i][0].equals(name)) {
                    sb.append(value);
                } else {
                    sb.append(attrs[i][1]);
                }
                ++i;
            }
            as = sb.toString();
        }
        this.getTarget().getModel().editObjectAttribute(this.getTarget(), ATTRIBUTES, as);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport(this, step);
        return this.validator;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        return !this.edit || !name.equals("name");
    }

    public String[][] getAttributes() {
        XModelObject o = this.getTarget();
        if (!(o instanceof AnyElementObjectImpl)) {
            o = o.getModel().createModelObject(XModelObjectLoaderUtil.ENT_ANY_ELEMENT, null);
            o.setAttributeValue(ATTRIBUTES, this.getTarget().getAttributeValue(ATTRIBUTES));
        }
        return ((AnyElementObjectImpl)o).getAttributes();
    }

    class Validator
    extends DefaultWizardDataValidator {
        Validator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (!AddAttributeToAnyElementSupport.this.edit && AddAttributeToAnyElementSupport.this.attributes.contains(name)) {
                this.message = MessageFormat.format("Attribute {0} already exists.", name);
            }
            if (this.message != null) {
                return;
            }
            if (AddAttributeToAnyElementSupport.this.edit && AddAttributeToAnyElementSupport.this.initialValue != null && name.equals(AddAttributeToAnyElementSupport.this.initialName) && AddAttributeToAnyElementSupport.this.initialValue.equals(data.getProperty("value"))) {
                this.message = "Please set new value.";
            }
        }
    }
}

