/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;

public class DefaultEditHandler
extends DefaultCreateHandler {
    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        if (!this.isEnabled(object) || this.data == null) {
            return;
        }
        Properties p = DefaultEditHandler.extractProperties(this.data[0]);
        this.setOtherProperties(object, p);
        DefaultEditHandler.edit(object, p);
    }

    public XEntityData[] getEntityData(XModelObject object) {
        super.getEntityData(object);
        if (this.data.length > 0) {
            XAttributeData[] ad = this.data[0].getAttributeData();
            int i = 0;
            while (i < ad.length) {
                String n = ad[i].getAttribute().getName();
                String v = object.getAttributeValue(n);
                if (v != null) {
                    ad[i].setValue(v);
                }
                if ((v = this.action.getProperty("attribute." + n)) != null) {
                    ad[i].setValue(v);
                }
                ++i;
            }
        }
        return this.data;
    }

    public static void edit(XModelObject object, Properties p, boolean openTransaction) throws XModelException {
        if (!openTransaction) {
            DefaultEditHandler.edit(object, p);
            return;
        }
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(MessageFormat.format("Edit {0}", DefaultCreateHandler.title(object, false)), 0);
        undo.addUndoable(u);
        long stamp = object.getTimeStamp();
        try {
            try {
                DefaultEditHandler.edit(object, p);
                if (stamp == object.getTimeStamp()) {
                    undo.rollbackTransactionInProgress();
                }
            }
            catch (Exception e) {
                undo.rollbackTransactionInProgress();
                XModelException.rethrow(e);
                u.commit();
            }
        }
        finally {
            u.commit();
        }
    }

    public static void edit(XModelObject object, Properties p) throws XModelException {
        XModelEntity e = object.getModelEntity();
        Enumeration<Object> en = p.keys();
        boolean active = object.isActive();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            if (e.getAttribute(n) == null) continue;
            String v = p.getProperty(n);
            if (!active) {
                object.setAttributeValue(n, v);
                continue;
            }
            object.getModel().changeObjectAttribute(object, n, v);
        }
    }
}

