/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.markers.ResourceMarkers;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IWatcherContributor;
import org.jboss.tools.common.model.project.ModelNatureExtension;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class Watcher
implements XModelTreeListener {
    protected XModel model;
    protected Map<String, IWatcherContributor> contributors = new HashMap<String, IWatcherContributor>();
    private boolean lock = false;
    String error = "initial";
    ResourceMarkers markers = null;

    public static Watcher getInstance(XModel model) {
        Watcher instance = (Watcher)model.getManager("Watcher");
        if (instance == null) {
            instance = new Watcher();
            instance.setModel(model);
            model.addManager("Watcher", instance);
            model.addModelTreeListener(instance);
        }
        return instance;
    }

    private Watcher() {
    }

    void updateContributors() {
        if (this.model == null) {
            return;
        }
        ModelNatureExtension[] es = ModelNatureExtension.getInstances();
        int i = 0;
        while (i < es.length) {
            String nature = es[i].getName();
            if (EclipseResourceUtil.hasNature(this.model, nature)) {
                if (!this.contributors.containsKey(nature)) {
                    String contributorName = es[i].getWatcherContributor();
                    Object watcher = ModelFeatureFactory.getInstance().createFeatureInstance(contributorName);
                    if (watcher instanceof IWatcherContributor) {
                        IWatcherContributor c = (IWatcherContributor)watcher;
                        c.init(this.model);
                        this.contributors.put(nature, c);
                    } else if (ModelPlugin.isDebugEnabled()) {
                        ModelPlugin.getPluginLog().logInfo("Class is not implemented IWatcherContributor interface!");
                    }
                }
            } else {
                this.contributors.remove(nature);
            }
            ++i;
        }
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public void forceUpdate() {
        if (this.model.getProperties().getProperty("eclipse.project") == null) {
            return;
        }
        XJob.addRunnable(new WatcherRunnable());
    }

    private void updateAll() {
        if (this.lock) {
            return;
        }
        this.lock();
        this.updateContributors();
        try {
            String err = null;
            for (IWatcherContributor c : this.contributors.values()) {
                if (!c.isActive()) continue;
                c.update();
                if (err != null) continue;
                err = c.getError();
            }
            this.setError(err);
            this.setCorrect(err == null);
            for (IWatcherContributor c : this.contributors.values()) {
                if (!c.isActive()) continue;
                c.updateProject();
            }
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public void structureChanged(XModelTreeEvent event) {
        XModel model = event.getModelObject().getModel();
        if (event.kind() == 3 && event.getModelObject() == model.getRoot()) {
            model.removeModelTreeListener(this);
            model.removeManager("Watcher");
            return;
        }
        this.forceUpdate();
    }

    public void nodeChanged(XModelTreeEvent event) {
        this.forceUpdate();
    }

    public void setError(String err) {
        boolean changed;
        if (this.markers == null) {
            this.markers = new RM();
            this.markers.setModelObject(FileSystemsHelper.getFileSystems(this.model));
            this.markers.clear();
        }
        boolean bl = this.error == null ? err != null : (changed = !this.error.equals(err));
        if (changed) {
            this.error = err;
            this.markers.update();
        }
    }

    private void setCorrect(boolean correct) {
        boolean b;
        XModelObject fs = FileSystemsHelper.getFileSystems(this.model);
        if (fs == null) {
            return;
        }
        boolean bl = b = !"yes".equals(fs.get("_hasErrors_"));
        if (b == correct) {
            return;
        }
        fs.set("_hasErrors_", correct ? "" : "yes");
        fs.fireObjectChanged("_hasErrors_");
    }

    class RM
    extends ResourceMarkers {
        public RM() {
            super(ResourceMarkers.JST_WEB_PROBLEM, ResourceMarkers.OLD_JST_WEB_PROBLEM);
        }

        protected String[] getErrors() {
            String[] stringArray;
            if (Watcher.this.error == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = Watcher.this.error;
            }
            return stringArray;
        }
    }

    class WatcherRunnable
    implements XJob.XRunnable {
        String id;

        WatcherRunnable() {
            this.id = "Watcher - " + XModelConstants.getWorkspace(Watcher.this.model);
        }

        public String getId() {
            return this.id;
        }

        public void run() {
            Watcher.this.updateAll();
        }
    }
}

